<!-- scv/resources/views/scvconf/edit.blade.php -->
@extends('layout.default')
@section('content')

<?php
 $id = $scvconf->id; $name = $scvconf->name; $enable = $scvconf->enable; $scvimage = $scvconf->scvimage; $maxlicense = $scvconf->maxlicense; $maxlimit = $scvconf->maxlimit; $created_at = $scvconf->created_at; $updated_at = $scvconf->updated_at; $enable_msg = $enable ? "checked" : ""; $license_msg = @exec('scvdirect -lic') ?: "** NO LICENSE FILE **"; ?>

<div class="page-header">
  <h3>システム設定変更</h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button type="button" onclick="location.href='{{URL::to('/scvmanager/scvconf')}}'">戻る</button>
<form action="/scvmanager/scvconf/{{$name}}" method="POST">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="hidden" name="_method" value="PUT">
  <input type="hidden" name="id" value="{{$id}}" />
  <input type="hidden" name="name" value="{{$name}}" />

  <div class="table-responsive">
  <table class="table table-condensed table-bordered">
  <tbody>
    <tr>
      <th align="left" class="gray">コンフィグ名</th>
      <td>{{ $name }}</td>
      <th align="left" class="gray">有効</th>
      <td>
        <label class="check_area">
          <input type="checkbox" name="enable" value="enable" {{$enable_msg}}>
        </label>
      </td>
    </tr>
    <tr>
      <th align="left" class="gray">ライセンスコア数（有効期限）</th>
      <td>{{$license_msg}}</td>
      <th align="left" class="gray">最大接続数</th>
      <td><input type="number" name="maxlimit" value="{{$maxlimit}}" min="0" step="1"></td>
    </tr>
    <tr>
      <th align="left" class="gray">SCVイメージ</th>
      <td>
        <select name="scvimage">
          <option selected>{{$scvimage}}</option>
          @foreach($scvimages as $si)
            @if($si === $scvimage)
              @continue
            @else
              <option value="{{$si}}">{{$si}}</option>
            @endif
          @endforeach
        </select>
      </td>
      <th align="left" class="gray">{{--ロードアベレージリミット--}}</th>
      <td>{{--<input type="number" step="0.1" name="loadavg" value="{{$loadavglimit}}">--}}</td>
    </tr>
{{--    <tr>
      <th align="left" class="gray">クライアントパスワード保存</th>
      <td>
        <select name="usersave">
          <option value="0" @if($usersave==0) selected @endif>保存しない</option>
          <option value="1" @if($usersave==1) selected @endif>保存の有無を確認</option>
          <option value="2" @if($usersave==2) selected @endif>強制保存</option>
        </select>
      </td>
      <th align="left" class="gray">バックアップファイル保存先</th>
      <td><input type="text" name="backup" value="{{$backupsavedir}}"></td>
    </tr> --}}
    <tr>
      <th class="gray"></th>
      @if(App\Libs\ClusterHelper::isMasterActive() || !App\Libs\ClusterHelper::isCluster())
        <td align="left" colspan="3"><input type="submit" name="submit" value="更新"></td>
      @else
        <td align="left" colspan="3"><input type="submit" name="submit" value="更新" disabled></td>
      @endif
    </tr>
  </tbody>
  </table>
  </div>
</form>
@endsection
