<!-- scv/resources/views/scvflow/check/index.blade.php -->
@extends('scvflow.default')
@section('title', '申請ファイル確認')
@section('description', '')
@section('head')
<style>
	table {
		width: 100%;
		margin-bottom: 1.5em;
	}
	.panel {	/* preview */
		position: relative;
		top: -3px;
		min-height: 10em;
	}
	#replaced-filename {
		display: inline-block;
	}
	label#replace-button {
		border: solid 1px #ccc;
		border-radius: 3px;
		margin: 0px;
		margin-left: 10px;
		padding-right: 5px;
		padding-left: 5px;
		background-color: #fff;
		line-height: 20px;
		color: #158;
		font-size: 11px;
		font-weight: normal;
	}
	label#replace-button:hover {
		background-color: #ddd;
		border-color: #aaa;
	}
</style>
@stop
@section('content')
<div class="row">
	<div class="col-md-5">
		<div class="pull-left">
		@if ($next_url)
			<a href="{{ $next_url }}">&lt; 次の申請</a>
		@else
			<span class="text-muted">&lt; 次の申請</span>
		@endif
		</div>
		<div class="pull-right">
		@if ($prev_url)
			<a href="{{ $prev_url }}">前の申請 &gt;</a>
		@else
			<span class="text-muted">前の申請 &gt;</span>
		@endif
		</div>
		<br>
		<form action="{{ $request->dl_key }}" method="post" enctype="multipart/form-data">
			<table class="table table-responsive">
				<tr>
					<td class="text-right" style="width: 120px">申請ユーザー :</td>
					<td>{{ $request->applicant_summary }}</td>
				</tr>
				<tr>
					<td class="text-right">申請ファイル :</td>
					@if ($request->status !== 'denied')
					<td>
						<a href="{{ $dl_url }}" id="original-filename">{{ $request->filename }}</a>
						<span id="replaced-filename"></span>
						@if ($rewrite_on && $request->status === 'waiting')
						<label id="replace-button">
							↪ ファイルの差し替え
							<input type="file" name="replace_file" style="display:none;">
						</label>
						@endif
					</td>
					@else
					<td style="text-decoration: line-through">{{ $request->filename }}</td>
					@endif
				</tr>

				<tr>
					<td class="text-right">申請種別 :</td>
					<td>{{ $request->jp_action_type }}</td>
				</tr>

				<tr>
					<td class="text-right">申請日時 :</td>
					<td>{{ $request->requested_at }}</td>
				</tr>
				<tr>
					<td class="text-right">コメント :</td>
				@if ($request->comment)
					<td>{{ $request->comment }}</td>
				@else
					<td style="color: gray">&lt;なし&gt;</td>
				@endif
				</tr>
				<tr>
					<td class="text-right">状態 :</td>
					<td>{{ $request->jpstatus }}</td>
				</tr>
			</table>
			<div class="authorize-forms">
				<div class="inline-block-wrapper">
					<div class="vcenter">
						@if ($request->status === 'waiting')
						<input type="button" value="承認" class="form-control btn btn-sm btn-default">
						<input type="button" value="否認" class="form-control btn btn-sm btn-default">
						@else
						<input type="button" value="承認" class="form-control btn btn-sm btn-default" disabled>
						<input type="button" value="否認" class="form-control btn btn-sm btn-default" disabled>
						@endif
					</div>
				</div>
				@if ($request->status === 'waiting')
				<textarea name="reason" class="form-control" placeholder="承認結果についてコメントができます。"></textarea>
				@else
				<textarea name="reason" class="form-control" placeholder="承認結果についてコメントができます。" disabled></textarea>
				@endif
			</div>
			<input type="hidden" name="action" value="">
			<input type="hidden" name="_token" value="{{ csrf_token() }}">
		</form>
	</div>
	<div class="col-md-7">
		<div class="panel panel-default">
			<div class="panel-heading">プレビュー</div>
			<div class="panel-body">{!! $preview_html !!}</div>
		</div>
	</div>
</div>
@stop
@section('script')
<script>
	// on authorization
	$('input[value=承認], input[value=否認]').on('click', function(e) {
		confirm_operation(this.value);
	});

	// on replacing file
	$('input[name=replace_file]').change(function() {
		var filepath = $(this).val();
		if (filepath.length === 0) return;
		filename = filepath.match('([^/\\\\]+)$')[1];
		$('#replaced-filename').text('⇢ ' + filename);
		$('#original-filename').css('text-decoration', 'line-through');
		alert('申請ファイルを置換しました。\nこのまま承認を行うと置換されたファイルが公開されます。');
	});
</script>
@stop