<!-- scv/resources/views/scvflow/default.blade.php -->
<!doctype html>
<html lang="ja">
	<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="pragma" content="no-cache" />
	<meta http-equiv="cache-control" content="no-cache" />
	<meta http-equiv="expires" content="0" />
	<meta name="description" content="Secure Console Vitrual">
	<meta name="author" content="tnakamura@jscom.co.jp">
	<meta name="csrf-token" content="{{ csrf_token() }}">
@if (View::hasSection('title'))
	<title>SCV Flow - @yield('title')</title>
@else
	<title>SCV Flow</title>
@endif
	<link rel="stylesheet" href="{!! asset('css/bootstrap.min.css') !!}">
	<link rel="stylesheet" href="{!! asset('css/bootstrap-theme.min.css') !!}">
	<link rel="stylesheet" href="{!! asset('css/jquery-ui.min.css') !!}">
	<link rel="stylesheet" href="{!! asset('css/scvflow/flowdownload.css') !!}">
	<style>
		* {
			margin: 0px;
			padding: 0px;
		}
		body {
			padding-top: 40px;
		}
		#footer {
			margin-top: 3em;
		}
		h1 {
			font-size: 24px;
			font-weight: bold;
		}
		h2 {
			font-size: 24px;
			font-weight: normal;
		}
		/* ドロップダウンをマウスホバーで表示 */
		.dropdown:hover > .dropdown-menu {
			display: block;
		}
		#errors li {
			list-style: none;
		}
		table, .panel {
			margin: 1em 0px;
		}
		.container-fluid {
			margin: 0px 2%;
		}

		/* 承認/否認 否認事由 の部分 */
		.authorize-forms {
		}
		.authorize-forms .vcenter {	/* 文字やボタンを垂直方向にセンタリングする */
			display: flex;
			-js-display: flex;	/* for IE8-9 */
			align-items: center;
			max-width: 400px;
		}
		.authorize-forms .inline-block-wrapper {	/* flex指定したボックスは横に広がるので、最小限に縮ませるためにinline-blockのボックスで囲む */
			display: inline-block;
			vertical-align: top;
			margin-bottom: 10px;
		}
		.authorize-forms input[value=承認] { width: 50px; color: #259; }	/* 各フォームの調整 */
		.authorize-forms input[value=否認] { width: 50px; margin: 0px 10px; color: #c33; }
		.authorize-forms input[value=まとめて承認] { width: 100px; margin-left: 10px; color: #259; }
		.authorize-forms input[value=まとめて否認] { width: 100px; margin: 0px 10px; color: #c33; }
		.authorize-forms input[value=申請キャンセル] { width: 110px; margin: 0px 10px; color: #259; }
		.authorize-forms textarea[name=reason] {
			display: inline-block;
		}
		.authorize-forms textarea[name=reason] {	/* フォーカスがないとき */
			width: 290px !important;
			height: 32px;
		}
		.authorize-forms textarea[name=reason].wide-form {	/* フォーカスしたとき */
			width: 70% !important;
			height: 100px;
		}
/*	コメントを外すとデザインが変わる
		.navbar {
			border: 0px;
			padding-left: 3%;
			background: -webkit-gradient(linear, left top, left bottom, color-stop(0.00, #7295b5), color-stop(0.47, #005081), color-stop(0.70, #147bb6), color-stop(0.94, #00abe5), color-stop(1.00, #02a8e4));
			background: -webkit-linear-gradient(top, #7295b5 0%, #005081 47%, #147bb6 70%, #00abe5 94%, #02a8e4 100%);
			background: -moz-linear-gradient(top, #7295b5 0%, #005081 47%, #147bb6 70%, #00abe5 94%, #02a8e4 100%);
			background: -o-linear-gradient(top, #7295b5 0%, #005081 47%, #147bb6 70%, #00abe5 94%, #02a8e4 100%);
			background: -ms-linear-gradient(top, #7295b5 0%, #005081 47%, #147bb6 70%, #00abe5 94%, #02a8e4 100%);
			background: linear-gradient(to bottom, #7295b5 0%, #005081 47%, #147bb6 70%, #00abe5 94%, #02a8e4 100%);
			box-shadow: 0px 9px 15px -3px rgba(0, 150, 255, 0.4);

		}
		.navbar a {
			text-shadow: 1px 1px 2px black;
			color: #fff !important;
		}
		.navbar li:hover {
			background-color: rgba(255, 255, 255, 0.2);
		}
		.navbar {
			animation: blink_bg 8s infinite;
		}
		@keyframes blink_bg{
			50% {
				box-shadow: 0px 9px 15px -3px rgba(0, 50, 255, 0.4);
			}
		}
*/
	</style>
	@yield('head')
	</head>
	<body>
		<nav class="navbar navbar-default navbar-fixed-top">
			<div class="navbar-header">
				<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
					<span class="sr-only">SCV Flow</span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
				</button>
				<a class="navbar-brand" href="{{ URL::to('/scvflow') }}">SCV Flow</a>
			</div>
			@if( !App\Libs\ClusterHelper::isCluster() || App\Libs\ClusterHelper::isCluster() && App\Libs\ClusterHelper::isMaster())
			<div id="navbar" class="navbar-collapse collapse">
				<ul class="nav navbar-nav">
					@if (\Auth::guard('scvuser')->check() && \Auth::guard('scvuser')->user()->privilege)
					<li>
						<a href="{{ URL::to('/scvflow/authorizer') }}">あなた宛の申請一覧</a>
					</li>
					@endif
					<li>
						<a href="{{ URL::to('/scvflow/applicant') }}">あなたの申請一覧</a>
					</li>
					@if (!empty(\Auth::user()) &&\App\Scvflow::isDownloadableByGroupId(\Auth::user()->groupid) && App\Libs\ConfHelper::scvconf('SCV_FLOW') > 0)
					<li>
						<a href="{{ URL::to('/scvflow/request/download/create') }}">ダウンロード申請</a>
					</li>
					@endif
{{--
					<li class="dropdown">
						<a href="{{ URL::to('/scvflow/xxxx') }}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">親メニュー<span class="caret hidden-xs"></span></a>
						<ul class="dropdown-menu hidden-xs">
							<li><a href="{{ URL::to('/scvflow/xxxx') }}">子メニュー1</a></li>
							<li><a href="{{ URL::to('/scvflow/xxxx') }}">子メニュー2</a></li>
						</ul>
					</li>
--}}
				</ul>
				@if(!Auth::guard('scvuser')->guest())
		    	<ul class="nav navbar-nav navbar-right">
		    		<p class="navbar-text">
		    			<span class="glyphicon glyphicon-user" title="{{ auth()->guard('scvuser')->user()->name }}"></span>
		    		</p>
		    	{{-- SAML認証のとき、現時点でシングルサインアウトに対応していないのでログアウトボタンを隠す --}}
		    	@if (\App\Libs\ConfHelper::scvconf('SCV_AUTHENTICATION') !== 'scvxsaml')
		    		<li data-toggle="bottom" data-placement="right" title="ログアウト"><a href="{{ URL::to('/scvflow/logout') }}"><span class="glyphicon glyphicon-log-out"></span></a></li>
		    	@endif
		    		<li>&nbsp;&nbsp;&nbsp;</li>
		    	</ul>
				@endif
			</div>
		    @endif
		</nav>
		<div class="container-fluid">
			{{-- タイトルと説明文を表示。不要なときはno_insert_topセクションを指定する --}}
			@if (! View::hasSection('no_insert_top'))
				<h1 class="page-header">@yield('title')</h1>
				@yield('description')
			@endif
			{{-- 結果の表示 （ "xxxxを作成しました" のような、青字のメッセージ） --}}
			@if (session('okmsg'))
				<div class="alert alert-info">{{ session('okmsg') }}</div>
			@endif
			{{-- 赤字のエラーメッセージの表示 --}}
			@if ($errors->any())
				<div id="errors" class="alert alert-danger">
					@foreach ($errors->all() as $error)
						<div>{{ $error }}</div>
					@endforeach
				</div>
			@endif
			
			@if( !App\Libs\ClusterHelper::isCluster() || App\Libs\ClusterHelper::isCluster() && App\Libs\ClusterHelper::isMaster())
				@yield('content')
			@else
    			<a href="{{ App\Libs\ClusterHelper::getMasterUrl() . '/scvflow' }}">マスターサーバはこちら</a>
			@endif
		</div>
		<div id="footer" class="text-center">{{ config('scv.copyright') }}</div>
		<script src="{!! asset('js/jquery-1.11.3.min.js') !!}"></script>
		<script src="{!! asset('js/bootstrap.min.js') !!}"></script>
		<script src="{!! asset('js/flexibility.js') !!}"></script>{{-- IE8-9でdisplay:flexを有効化する --}}
		@yield('script')
		<script>
			// ドロップダウンで親リンクを有効化する
			$('.dropdown-toggle').click(function() {
				var location = $(this).attr('href');
				window.location.href = location;
				return false;
			});
			// テキストエリアにフォーカスを合わせると拡張する
			$('[name=reason]').on(
				{
					'focus': function() {
						$(this).addClass('wide-form');
					},
					'blur': function() {
						$(this).removeClass('wide-form');
					}
				}
			);
			// 申請操作を行う直前に確認ダイアログを表示する
			function confirm_operation(act) {
				if (window.confirm('選択された申請を' + act + 'してもよろしいですか？')) {
					$('input[name="action"]').val(act);
					$('.authorize-forms').parent().submit();
				}
			}
		</script>
	</body>
</html>