<!-- scv/resources/views/scvflow/request/download/create.blade.php -->
@extends('scvflow.default')
@section('title', 'ダウンロード申請')
@section('description', '')
@section('content')

@if (!empty($authorizers))
{{ Form::open(['url' => '/scvflow/request/download', 'method' => 'post', "enctype" => "multipart/form-data"])}}
  <table class="table table-condensed table-bordered">
    <tr>
      <th>申請ファイル</th>
      <td>
         {{Form::file('request_file[]', ['multiple' => "multiple", 'required' => 'true'])}} 
        <div class="list">
          <ul></ul>
        </div>
      </td>
    </tr>
    <tr>
      <th>承認者</th>
      <td>
        <input type="text" id="list_search" placeholder="検索" value="{{$scvuser->department}}"/>
        <table id="authorizers_table" class="table table-condensed table-bordered pwd-policy-wrap tablesorter table-striped">
            <thead>
              <th>選択</th>
              <th>ユーザ名</th>
              <th>氏名</th>
              <th>部署名</th>
              <th>役職名</th>
              <th>社員番号</th>
              <th>任意データ1</th>
              <th>任意データ2</th>
              <th>任意データ3</th>
            </thead>
            @foreach($authorizers as $authorizer)
            <tr>
              <td class="col-md-1"><input type="checkbox" name="authorizer_id[]" value={{$authorizer['id']}}></td>
              <td class="col-md-1">{{$authorizer['name']}}</td>
              <td class="col-md-1">{{$authorizer['jpname']}}</td>
              <td class="col-md-1">{{$authorizer['department']}}</td>
              <td class="col-md-1">{{$authorizer['post']}}</td>
              <td class="col-md-1">{{$authorizer['employee_id']}}</td>
              <td class="col-md-1">{{$authorizer['custom_data1']}}</td>
              <td class="col-md-1">{{$authorizer['custom_data2']}}</td>
              <td class="col-md-1">{{$authorizer['custom_data3']}}</td>
            </tr>
            @endforeach
            <div id="no_result">
              <p>見つかりませんでした。</p>
            </div>
        </table>
      </td>
    </tr>
    <tr>
      <th>コメント</th>
      <td>
        {{ Form::textarea('comment', null, ['placeholder' => "省略可能です。"]) }}
      </td>
    </tr>
  </table>
  {{ Form::submit('申請', ['class' => 'btn btn-sm btn-default']) }}
{{ Form::close() }}
@else
<p>承認権限を持つユーザが存在しないため、ダウンロード申請を利用することはできません。</p>
@endif
@stop
@section('script')
<script type="text/javascript" src="{!! asset('js/jquery-1.11.3.min.js') !!}"></script>
<script src="{!! asset('js/jquery.quicksearch.min.js') !!}"></script>
<script src="{!! asset('js/scvflow/searchAuthorizers.js') !!}"></script>
<script src="{!! asset('js/scvflow/displayFilename.js') !!}"></script>
@stop