<!-- scv/resources/views/scvflow/login.blade.php -->
<?php
use App\Libs\ClusterHelper as CH; $master_url = 'https://' . CH::getMasterAddress() . '/scvflow'; ?>
@extends('scvflow/default')
@if( !App\Libs\ClusterHelper::isCluster() || App\Libs\ClusterHelper::isCluster() && App\Libs\ClusterHelper::isMaster())
  @section('title', 'ログイン')
  @section('description')
    <span class="text-info">ユーザ名は組織名と合わせて "組織名/ユーザ名" のように入力してください。<br>
    なお、SCV Managerと同時にログインすることはできません。</span>
  @stop
  @section('content')
  @if ($showing_form)
    <table class="table-condensed">
      <form method="POST" action="/scvflow/login" width="400">
        {!! csrf_field() !!}
        <input type="hidden" name="intended" value="{{ session('url.intended', '/scvflow') }}">
        <tr>
          <td>ユーザ名</td>
          <td><input type="text" name="username" value="{{ old('username') }}" autofocus></td -->
        </tr>
        <tr>
          <td>パスワード</td>
          <td><input type="password" name="password" id="password"></td>
        <tr>
          <td></td>
          <td><button type="submit">ログイン</button></td>
        </tr>
      </form>
    </table>
  @endif
@stop
@else
  @section('description')
    <div class="page-header">
      <h3>このサーバはMasterサーバではありません。</h3>
      <div id="errors" class="alert alert-danger">
      <h4 style="color:red">SCV Flowによる操作はマスターサーバで行ってください</h4>
    </div>
  @stop
@endif
