<!-- scv/resources/views/scvflow/requests/index.blade.php -->
@extends('scvflow.default')
@section('title', $login_user->jpname . 'さんのアップロード申請一覧')
@section('description', '')
@section('head')
<style>
	table {
		margin-top: 5px;
	}
	th:nth-child(1), td:nth-child(1) {
		text-align: center;
	}
	td a {
		display: block !important;
		height: 100% !important;
		vertical-align: middle !important;
	}
	.min-td {
		padding: 0px !important;
	}
</style>
@stop
@section('content')
<table class="table table-responsive table-hover">
	<tr>
		<th>ファイル名</th><th>コメント</th><th>申請者</th><th>申請日時</th>
	</tr>
@forelse ($your_uploads as $upload)
	<tr>
		<td class="col-md-2"><a href="{{ url('scvflow/preview/' . $upload->dl_key) }}">{{ $upload->filename }}</a></td>
	@if ($upload->comment)
		<td class="col-md-4" style="width: 16em">{{ $upload->comment }}</td>
	@else
		<td class="col-md-4" style="width: 16em; color: gray">&lt;なし&gt;</td>
	@endif
		<td class="col-md-2">{{ $upload->applicant_department }}:{{ $upload->applicant_jpname }}</td>
		<td class="col-md-3">{{ $upload->requested_at }}</td>
	</tr>
@empty
	<tr>
		<td colspan="6" style="text-align: center; line-height: 3em">{{ $login_user->jpname }}さんの新たなアップロード申請はありません。</td>
	</tr>
@endforelse
</table>
@stop
@section('script')
<script>
	var chk_all = $('table input:checkbox:first');
	var chks = $('table input[name="chk_dl_keys[]"]');
	check_all(chk_all, chks);

	// セルの全域からチェックできるようにする
	$('tr th:first-child, tr td:first-child').on('click', function() {
		var its_chk = $(this).find('input:checkbox');
		its_chk.focus();
		$(its_chk).prop('checked', !$(its_chk).prop('checked')).change();
		return true;
	});
	chk_all.on('click', function(e) {
		e.stopPropagation();
		return true;
	});
	chks.on('click', function(e) {
		e.stopPropagation();
		return true;
	});

	$('#switch-min-td').on('change', function() {
		$('td').toggleClass('min-td');
	});

	// チェックボックスの一括機能
	function check_all(chk_all, chks) {
		chk_all.on('change', function() {
			chks.prop('checked', this.checked);
		});
		chks.on('change', function() {
			if (this.checked) {
				for (var i = 0; i < chks.length; ++i)
					if (!chks[i].checked) return true;
				chk_all.prop('checked', true);
			} else
				chk_all.prop('checked', false);
			return true;
		});
	}
</script>
@stop