<!-- scv/resources/views/scvflow/applicant/index.blade.php -->
<?php
use App\Scvflow; ?>
{{-- 申請者用の一覧と承認者用の一覧はほとんど同じ構成なので、双方でこのビューを使う --}}
@extends('scvflow.default')
@section('title', $title)
@section('description', '')
@section('head')
<link rel="stylesheet" href="{!! asset('css/jquery.datetimepicker.css') !!}" />
<link rel="stylesheet" href="{!! asset('css/search-box.css') !!}" />
<style>
	/* テーブル内のリンクを広くする */
	td a {
		display: block !important;
		height: 100% !important;
		vertical-align: middle !important;
	}
	/* 承認結果カラムの中央寄せ */
	tr th:nth-child(1), tr td:nth-child(1), tr th:nth-child(2), tr td:nth-child(2) {
		text-align: center;
	}
	/* 同カラムの背景色をデフォルトより明るくする */
	table .info {
		background-color: #ddeeff !important;
	}
	table .danger {
		background-color: #ffeedd !important;
	}
</style>
@stop
@section('content')
{{ $cnt }} 件の申請があります。<span class="text-info">承認</span>されたファイルは<span class="text-info">青色</span>、<span class="text-danger">否認</span>されたファイルは<span class="text-danger">赤色</span>で表示しています。
@if ($authorizer_page)
	<br>ファイル名をクリックすると、各申請の詳細情報を確認できます。
@endif
<div class="search-box" style="margin-top: 10px">
	{{ Form::open(['method' => 'post']) }}
		状態 : 
		{{ Form::select('status', [
			''          => '全て',
			'waiting'   => '承認待ち',
			'permitted' => '承認済み',
			'denied'    => '否認済み'
		], $status) }} 
		期間 : 
		{{ Form::text('start_date', $start_date, ['class' => 'datetime', 'readonly']) }} ～
		{{ Form::text('end_date', $end_date, ['class' => 'datetime', 'readonly']) }}
		{{ Form::text('keyword', $keyword, ['placeholder' => '検索ワード']) }}
		ソート : 
		{{ Form::select('sort', [
			'asc'  => '申請日(昇順)',
			'desc' => '申請日(降順)'
		], $sort) }} 
		{{ Form::submit('この条件で検索', ['name' => 'action']) }}
	{{ Form::close() }}
</div>
{{ Form::open(['method' => 'post']) }}
	<table class="table table-responsive table-striped">
		<tr>
			<th>{{ Form::checkbox('chk_all', 0, false) }}</th>
			<th>状態</th>
			<th>申請種別</th>
			<th>ファイル名</th>
			<th>コメント</th>
			@if ($authorizer_page)
			<th>申請者</th>
			@else
			<th>承認者</th>
			@endif
			<th>申請日時</th>
			<th>承認日時</th>
			<th>承認者コメント</th>
		</tr>
	@forelse ($requests as $request)
		<tr>
		{{-- 1番目のカラム（チェックボックス） --}}
			<td class="col-md-1">{{ Form::checkbox('dl_keys[]', $request->dl_key, false, $request->status === 'waiting' ? [] : ['disabled']) }}</td>

		{{-- 2番目のカラム（状態） --}}
		@if ($request->status === 'waiting')
			<td class="col-md-1">{{ $request->jpstatus }}</td>
		@elseif ($request->status === 'permitted')
			<td class="col-md-1 info">{{ $request->jpstatus }}</td>
		@elseif ($request->status === 'denied')
			<td class="col-md-1 danger">{{ $request->jpstatus }}</td>
		@else
			<td class="col-md-1">{{ $request->jpstatus }}</td>
		@endif

		{{-- 3番目のカラム (申請種別) --}}
		    <td class="col-md-1">{{ $request->jp_action_type }}</td>

		{{-- 4番目のカラム（ファイル名） --}}
			@if ($authorizer_page)
			<td class="col-md-2"><a href="{{ Scvflow::get_auth_url($request->dl_key) }}">{{ $request->filename }}</a></td>
			@elseif ($request->status === 'permitted')
			<td class="col-md-2"><a href="{{ Scvflow::get_dl_url($request->dl_key) }}">{{ $request->filename }}</a></td>
			@else
			<td class="col-md-2">{{ $request->filename }}</td>
			@endif
		{{-- 5番目のカラム（コメント） --}}
		@if ($request->comment)
			<td class="col-md-2">{{ $request->comment }}</td>
		@else
			<td class="col-md-2" style="color: gray">&lt;なし&gt;</td>
		@endif
		{{-- 6番目のカラム（申請者 or 承認者の部署と氏名） --}}
			@if ($authorizer_page)
			<td class="col-md-2">{{ $request->applicant_summary }}</td>
			@else
			<td class="col-md-2">{!! nl2br(e($request->authorizers_overall_summary)) !!}</td>
			@endif
		{{-- 7番目のカラム（申請日時） --}}
			<td class="col-md-1">{{ $request->requested_at }}</td>
		{{-- 8番目のカラム（承認日時） --}}
			@if ($request->status == 'waiting')
			<td class="col-md-1" style="color: gray">&lt;未承認&gt;</td>
			@else
			<td class="col-md-1">{{ $request->authorized_at }}</td>
			@endif
		{{-- 9番目のカラム（承認者コメント） --}}
		@if ($request->why_denied)
			<td class="col-md-2">{{ $request->why_denied }}</td>
		@else
			<td class="col-md-2" style="color: gray">&lt;なし&gt;</td>
		@endif
		</tr>
	@empty
		<tr>
			<td colspan="8" style="text-align: center; line-height: 3em">条件に一致する申請はありません。</td>
		</tr>
	@endforelse
	</table>
	<div class="authorize-forms">
		<div class="inline-block-wrapper">
			<div class="vcenter">
				チェックしたファイルを
				@if ($authorizer_page)
				<input type="button" value="まとめて承認" class="form-control btn btn-sm btn-default">
				<input type="button" value="まとめて否認" class="form-control btn btn-sm btn-default">
				@else
				<input type="button" value="申請キャンセル" class="form-control btn btn-sm btn-default">
				@endif
				<input type="hidden" name="action" value="">
			</div>
		</div>
	@if ($authorizer_page)
		<textarea name="reason" class="form-control" placeholder="承認者コメントをコメントできます。"></textarea>
	@endif
	</div>
{{ Form::close() }}
{{ $requests->appends(compact('status', 'start_date', 'end_date', 'keyword', 'sort'))->links() }}	
@stop
@section('script')
<script src="{!! asset('js/jquery.datetimepicker.full.min.js') !!}"></script>
<script src="{!! asset('js/search-box.js') !!}"></script>
<script>
{{-- チェックボックスの全選択機能関連 --}}
(function() {
	var chk_all = $('input[name="chk_all"]');
	var chks = $('input[name="dl_keys[]"]');

	{{-- セルの全域からチェックできるようにする --}}
	$('tr th:first-child, tr td:first-child').on('click', function() {
		var its_chk = $(this).find('input:checkbox');
		if (its_chk.is(':disabled'))
			return false;
		its_chk.focus();
		$(its_chk).prop('checked', !$(its_chk).prop('checked')).change();
		return true;
	});

	{{-- チェックボックス自身がクリックされた場合はセルにクリックイベントを回さない --}}
	chk_all.on('click', function(e) {
		e.stopPropagation();
		return true;
	});
	chks.on('click', function(e) {
		e.stopPropagation();
		return true;
	});

	{{-- 全選択用チェックボックスとの同期処理 --}}
	chk_all.on('change', function() {
		chks.not(':disabled').prop('checked', this.checked);
	});
	chks.on('change', function() {
		var is_all_checked = function() {
			for (var i = 0; i < chks.length; ++i)
				if (!chks[i].disabled && !chks[i].checked)
					return false;
			return true;
		}
		chk_all.prop('checked', is_all_checked(chks));
	});
})();

$('input[value=まとめて承認]').on('click', function(e) {
	if (!check_file_selected()) return;
	confirm_operation('承認');
});

$('input[value=まとめて否認]').on('click', function(e) {
	if (!check_file_selected()) return;
	confirm_operation('否認');
});

$('input[value=申請キャンセル]').on('click', function(e) {
	if (!check_file_selected()) return;
	confirm_operation('取消');
});

function check_file_selected() {
	var checked_cnt = $('td input:checked').length;
	if (checked_cnt === 0) {
		alert('ファイルが選択されていません。');
		return false;
	}
	return true;
}
</script>
@stop