<!-- scv/resources/views/scvgroups/create.blade.php -->
@extends('layout.default')
@section('content')

{{-- セレクトボックスを追加する領域 --}}
<style>
  #visionprof select{
    display: block;
    margin-bottom: 5px;
  }
</style>

<div class="page-header">
  <h3>グループ作成</h3>
</div>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@else
  <p class="text-info">グループ名と各セキュリティポリシーを入力してください。</p>
@endif

<?php
 $scvpriority = 'NORMAL'; $scvquality = 'NORMAL'; if(!Input::old()){ $enable_msg = "checked"; $all_msg = "checked"; $hour = '00:00-24:00'; $runmode = 'SINGLE'; $image = 'DEFAULT'; $firefoxprofile_id = '0'; $shareprofile_id = '0'; $org_id = '0'; }else{ if(Input::old("enable") == "enable") $enable_msg = "checked"; else $enable_msg = ""; if(Input::old("all_check") == "on") $all_msg = "checked"; else $all_msg = ""; $hour = Input::old("hour") ?: "00:00-24:00"; $runmode = Input::old("runmode")?: "MULTI"; $image = Input::old("image") ?: "DEFAULT"; $firefoxprofile_id = Input::old("firefoxprofile_id") ?: ""; $shareprofile_id = Input::old("shareprofile_id") ?: ""; $org_id = Input::old("organization_id") ?: "0"; } ?>
<button type="button" onclick="location.href='{{URL::to('/scvmanager/scvgroups')}}'">戻る</button>

<form action="{{URL::to('/scvmanager/scvgroups')}}" method="POST">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <div class="table">
  <table class="table table-condensed table-bordered ">
    <tr>
      <td class="gray icon-td col-md-1"></td>
      <th class="gray col-md-2">グループ名</th>
      <td class="col-md-3">
        <input type="text" name="name" size="20" value="{{Input::old('name')}}" placeholder="<GROUPNAME>" autofocus>
        <span id="scvgroup-name"></span>
      </td>
      <td class="gray icon-td col-md-1"></td>
      <th class="gray col-md-2">組織</th>
      <td class="col-md-3">
        <select name="organization_id">
          @foreach($organizations as $org)
            @if($org->id == $org_id)
              <option value="{{$org->id}}" selected>{{$org->name}}</option>
            @else
              <option value="{{$org->id}}">{{$org->name}}</option>
            @endif
          @endforeach
        </select>
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">有効</th>
      <td>
        <label class="check_area">
          <input type="checkbox" name="enable" value="enable" {{$enable_msg}}>
        </label>
      </td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">PRIORITY</th>
      <td>{{$scvpriority}}<input type="hidden" name="scvpriority" value="{{$scvpriority}}"></td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">曜日有効</th>
      <td>
        <label class="check_area">{{ Form::checkbox('ena_dayofweek', 'ena_dayofweek') }}</label>
      </td>
      <td class="gray"></td>
      <th align="left" class="gray">許可曜日</th>
      <td class="weeks">
        <label style="margin-left:5px;" class="checkbox-inline">{{ Form::checkbox('all_chk', null, true) }}ALL</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[0]', 'SUN') }}SUN</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[1]', 'MON') }}MON</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[2]', 'TUE') }}TUE</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[3]', 'WED') }}WED</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[4]', 'THU') }}THU</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[5]', 'FRI') }}FRI</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[6]', 'SAT') }}SAT</label>
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">時間有効</th>
      <td>
        <label class="check_area">{{ Form::checkbox('ena_hour', 'ena_hour') }}</label>
      </td>
      <td class="gray"></td>
      <th align="left" class="gray">許可時間</th>
      <td><input type="text" name="hour" size="20" value="{{$hour}}"></td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th align="left" class="gray">Firefox保存</th>
      <td>
        <label class="check_area">{{ Form::checkbox('firefoxsave', 'firefoxsave') }}</label>
      </td>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th align="left" class="gray">コピー＆ペースト</th>
      <td>
        <select name="copypaste">
          <option value="0" @if(Input::old('copypaste')=="0") selected @endif>{{ $copypaste_options[0] }}</option>
          <option value="1" @if(Input::old('copypaste')=="1") selected @endif>{{ $copypaste_options[1] }}</option>
          <option value="2" @if(Input::old('copypaste')=="2") selected @endif>{{ $copypaste_options[2] }}</option>
          <option value="3" @if(Input::old('copypaste')=="3") selected @endif>{{ $copypaste_options[3] }}</option>
        </select>
        <span id="scvgroup-copypaste"></span>
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">ウィルスチェック</th>
      <td>
        <select name="vck_flag">
          @if(empty($availableOptions) || $availableOptions['vck'])
            <option value="0" @if(Input::old('vck_flag')=="0") selected @endif>無効</option>
            <option value="1" @if(Input::old('vck_flag')=="1") selected @endif>ウィルスチェック</option>
            <option value="2" @if(Input::old('vck_flag')=="2") selected @endif>ウィルスチェックダウンロード</option>
          @else
            <option value="0" selected disabled>利用不可</option>
          @endif
        </select>
      </td>
      <td class="gray"></td>
      <th align="left" class="gray">無害化オプション</th>
      <td>
        <select name="stz_flag">
          @if(empty($availableOptions) || $availableOptions['stz'])
            <option value="0" @if(Input::old('stz_flag')=="0") selected @endif>無効</option>
            <option value="1" @if(Input::old('stz_flag')=="1") selected @endif>SCVXSanitizer</option>
            <label class="checkbox-inline" style="margin-left:5px;"><input type="checkbox" name="stz_dl_flag" value="1" @if(Input::old('stz_dl_flag')=="1") checked  @endif>ダウンロード有効</label>
            <label class="checkbox-inline"><input type="checkbox" name="tck_stz_dl_flag" value="1" @if(Input::old('tck_stz_dl_flag')=="1") checked  @endif>サンドボックス連携<label>
          @else
            <option value="0" selected disabled>利用不可</option>
          @endif
        </select>
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">サンドボックスチェック</th>
      <td>
        <select name="tck_flag">
          @if(empty($availableOptions) || $availableOptions['tck'])
            <option value="0" @if(Input::old('tck_flag')=="0") selected @endif>無効</option>
            <option value="1" @if(Input::old('tck_flag')=="1") selected @endif>サンドボックスチェック</option>
            <option value="2" @if(Input::old('tck_flag')=="2") selected @endif>サンドボックスチェックダウンロード</option>
          @else
            <option value="0" selected disabled>利用不可</option>
          @endif
        </select>
      </td>
      <td class="gray"></td>
      <th align="left" class="gray">アップロード有効</th>
      <td>
        <label class="check_area">
          <input type="checkbox" name="upload" value="upload" @if(Input::old('upload')=="upload") checked  @endif>
        </label>
      </td>
    </tr>
    @if($enable_flow)
    <tr>
    </td>
    <td class="gray"></td>
    <th class="gray">SCV Flow</th>
    <td>
      {{ Form::select('scv_flow', ['0' => '無効', '3' => '有効', '1' => 'アップロードのみ', '2' => 'ダウンロードのみ'])}}
    </td>
    <td class="gray"></td>
      <th align="left" class="gray"></th>
      <td></td>
    </tr>
    @endif
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">印刷有効</th>
      <td>
        <select name="print">
          <option value="0" @if(Input::old('print')=="0") selected @endif>無効</option>
          <option value="1" @if(Input::old('print')=="1") selected @endif>有効</option>
        </select>
      </td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">ファイルマネージャ表示オプション</th>
      <td>
        <label style="margin-left:5px;" class="checkbox-inline">{{ Form::checkbox('nemo_settings[]', 'menubar') }}メニューバー</label>
        <label class="checkbox-inline">{{ Form::checkbox('nemo_settings[]', 'sidebar') }}サイドバー</label>
      </td>
    </tr>
    <tr>
      <td rowspan="2" class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th rowspan="2" align="left" class="gray">アイドルタイムアウト</th>
      <td>タイムアウト : <input type="number" name="idle_timeout" min="0" max="10000" step="1" value="{{Input::old('idle_timeout')}}"> 分
      <td rowspan="2" class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th rowspan="2" align="left" class="gray">強制タイムアウト</th>
      <td>タイムアウト : <input type="number" name="force_timeout" min="0" max="10000" step="1" value="{{Input::old('force_timeout')}}"> 分
    </tr>
    <tr>
      <td>メッセージ : <input type="number" name="idle_msg_wait" min="0" max="10000" step="1" value="{{Input::old('idle_msg_wait')}}"> 秒</td>
      <td>メッセージ : <input type="number" name="force_msg_wait" min="0" max="10000" step="1" value="{{Input::old('force_msg_wait')}}"> 秒</td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">アプリケーション</th>
      <td>{{ Form::text('applist', 'firefox') }}</td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">実行モード</th>
      <td>
        <select name="runmode">
          <option value="SINGLE" @if(old('runmode') == "SINGLE") selected @endif>SINGLE</option>
          <option value="MULTI" @if(old('runmode') == "MULTI") selected @endif>MULTI</option>
        </select>
        <span id="run-mode"></span>
      </td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th class="gray">Firefox設定</th>
      <td>
          <select name="firefoxprofile_id" class="firefoxprofile_id">
          <option value="">設定しない</option>
          @foreach($firefoxprofs as $fp)
            @if($fp->id == $firefoxprofile_id)
              <option value="{{$fp->id}}" selected>{{$fp->name}}</option>
            @else
              <option value="{{$fp->id}}">{{$fp->name}}</option>
            @endif
          @endforeach
        </select>
      </td>
      <td class="gray"><span class="scvx-icon"></td>
      <th class="gray">共有フォルダ設定</th>
      <td>
        <select name="shareprofile_id" class="shareprofile_id">
        <option value="">設定しない</option>
        @foreach($shareprofiles as $sf)
          @if($sf->id == $shareprofile_id)
            <option value="{{$sf->id}}" selected>{{$sf->shname}}</option>
          @else
            <option value="{{$sf->id}}">{{$sf->shname}}</option>
          @endif
        @endforeach
        </select>
      </td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th class="gray">SCVX Chrome設定</th>
      <td>{{ Form::select('scvx_chrome_setting_id', $scvx_chromes->where('organization_id', \Auth::user()->organization_id)->pluck('name', 'id')->prepend('設定しない', '0'), null,  ['class' => 'scvx_chrome_setting_id']) }}</td>
      <td class="gray"></td>
      <th class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></td>
      <th align="left" class="gray">SCVイメージ</th>
      <td>
        <select name="image">
          <option value="DEFAULT">DEFAULT</option>
            @foreach ($scvimages as $si)
              @if($si == $image)
                <option value="{{$si}}" selected>{{$si}}</option>
              @else
                <option value="{{$si}}">{{$si}}</option>
              @endif
            @endforeach
        </select>
      </td>
      <td class="gray"></td>
      <th class="gray"></th>
      <td></td>
    </tr>
    @if(App\Libs\ConfHelper::isMaxConnect() || App\Libs\ConfHelper::isDirectPrint())
      @if(App\Libs\ConfHelper::isMaxConnect())
        <td class="gray"><span class="scvx-icon"></td>
        <th align="left" class="gray">最大接続数
          <span class="glyphicon glyphicon-question-sign text-info" id="max_pop" data-toggle="popover" title="最大接続数" data-content="-1で無制限になります。">
        </th>
        <td><input type="number" name="maxlimit" value="-1" min="-1" step=1 max="99999"></td>
      @endif
      @if(App\Libs\ConfHelper::isDirectPrint())
      <tr>
        <td class="gray"><span class="scvx-icon"></td>
        <th align="left" class="gray">プリンタ設定</th>
        <td colspan="3">
          <textarea name="custom" rows="3" cols="80" warp="off">{{Input::old('custom')}}</textarea>
        </td>
      </tr>
      @endif
    @endif
    <tr>
      <td class="gray"><span class="revobr-icon"></td>
      <th align="left" class="gray">RevoBrowser設定</th>
      <td>
        <select name="br_setting_id">
          <option value="none">なし</option>
          @foreach ($br_settings as $bs)
              <option value="{{$bs->id}}">{{$bs->name}}</option>
          @endforeach
        </select>
      </td>
      <td class="gray"><span class="revobr-icon"></td>
      <th align="right" class="gray">オフライン起動有効期限</th>
      <td>
        <input type="number" name="offline_expiration" value="0" step="1" min="0" max="240" />時間
        <span id="offline-cache-expiration"></span>
      </td>
    </tr>
    <tr>
      <td class="gray"><span class="revodt-icon"></td>
        <th align="left" class="gray">デスクトップ設定</th>
        <td>
          <div id="visionprof"></div>
          <input id="visionprof-del" type="button" value="削除">
          <input type="hidden" name="visionprofile_list" value="">
        </td>
        <td class="gray"></td>
        <th align="right" class="gray"></th>
        <td></td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">備考</th>
      <td><input type="text" name="comment" size="20" value="{{Input::old('comment')}}"></td>
      <td class="gray"></td>
      <th align="right" class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <td></td>
      <td colspan="5"><input type="submit" value="登録"></td>
    </tr>
  </table>
  </div>
</form>
@stop
@section('script')
<script src="{!! asset('js/tooltips.js') !!}"></script>
<script src="{!! asset('js/multiple-selectboxes.js') !!}"></script>
<script src="{!! asset('js/scvmanager/scvgroup.js') !!}"></script>
<script src="{!! asset('js/scvmanager/sync_firefoxprof.js') !!}"></script>
<script src="{!! asset('js/scvmanager/sync_shareprofile.js') !!}"></script>
<script src="{!! asset('js/scvmanager/sync_scvx_chrome_setting.js') !!}"></script>
<?php
$visionprofiles = \App\Visionprofile::all(); $select_texts = []; foreach ($visionprofiles as $visionprofile) $select_texts[] = $visionprofile->name; $js_arr = '[\'選択してください\',\'' . join('\',\'', $select_texts) . '\']'; ?>
<script>
  var flow_available = {{ $flow_available }};
  check_all_weeks();

  let msb = new MultipleSelectBoxes({
    location:              $('#visionprof'),
    removeButton:          $('#visionprof-del'),
    bindForm:              $('input[name=visionprofile_list]'),
    bindDelimitor:         ',',
    itemTexts:             {!! $js_arr !!},
    itemValues:            {!! $js_arr !!},
    initialSelectedItems:  [],
    minShowingSelects:     1,
    maxShowingSelects:     3,
    allowDuplicate:        false,
    selectClassName:       'visionprof-selects',
    msgSelectsMaxExceeded: 'これ以上は選択できません',
    msgDuplicatedSelect:   '項目の重複はできません',
    errorAlert:            false
  });
</script>
@stop