<!-- scv/resources/views/scvgroups/csv.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>グループ一括登録</h3>
</div>
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
<button type="button" onclick="history.back()">戻る</button>

<h4>csvダウンロード</h4>
<button id="download">csvダウンロード</button>

<h4>csvアップロード</h4>
<form id="upload" action="{{URL::to('/scvmanager/scvgroups/csv_upload')}}" method="post" enctype="multipart/form-data">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="file" name="file"><br>
  <input id="csv_submit" type="submit" value="送信">
</form>
@endsection
@section('script')
<script type="text/javascript" src="{!! asset('js/js.cookie-2.2.1.min.js') !!}"></script>
<script type="text/javascript">
  $('#download').click(function (){
    if (confirm("csvをダウンロードしてもよろしいですか？")){
      location.href = "{{URL::to('/scvmanager/scvgroups/csv_download')}}";
    }
  });

  $('#upload').submit(function (){
    $('#csv_submit').prop('disabled', true).val('処理中');
    var intervalId = setInterval(function () {
      if (Cookies.get('EXPORTED')) {
        $('#csv_submit').prop('disabled', false).val('送信');
        clearInterval(intervalId);
        Cookies.remove('EXPORTED');
      }
    }, 1000);
  });
</script>
@endsection
