<!-- scv/resources/views/scvgroups/edit.blade.php -->
@extends('layout.default')
@section('content')
{{-- セレクトボックスを追加する領域 --}}
<style>
  #visionprof select{
    display: block;
    margin-bottom: 5px;
  }
</style>

<div class="page-header">
  <h3>グループ変更</h3>
</div>
@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@else
  <p class="text-info">グループ名と各セキュリティポリシーを入力してください。</p>
@endif
<?php
 $enable_msg = ""; $ena_dayofweek_msg = ""; $ena_hour_msg = ""; $firefoxsave_msg = ""; $copypaste_msg = ""; $upload_msg = ""; $nemo_menubar_msg = ""; $nemo_sidebar_msg = ""; function parseNemoSettings($v){ $a = array(); if($v & 0x01) $a[] = "menubar"; if($v & 0x02) $a[] = "sidebar"; return $a; } if (isset($scvgroup)){ $id = $scvgroup->id; $name = $scvgroup->name; $enable = $scvgroup->enable; $comment = $scvgroup->comment; $dayofweeks = explode(",", $scvgroup->dayofweek); $hour = $scvgroup->hour; $ena_dayofweek = $scvgroup->ena_dayofweek; $ena_hour = $scvgroup->ena_hour; $firefoxsave = $scvgroup->firefoxsave; $copypaste = $scvgroup->copypaste; $applist = $scvgroup->applist; $runmode = $scvgroup->runmode; $image = $scvgroup->image; $print = $scvgroup->print; $sanitize = $scvgroup->sanitize; $download = $scvgroup->download; $upload = $scvgroup->upload; $maxlimit = $scvgroup->maxlimit; $scvpriority = $scvgroup->scvpriority; $firefoxprofile_id = $scvgroup->firefoxprofile_id; $shareprofile_id = $scvgroup->shareprofile_id; $org_id = $scvgroup->organization_id; $scvquality = $scvgroup->scvquality; $custom = urldecode($scvgroup->custom); $nemo_settings = parseNemoSettings($scvgroup->nemo_settings); $idle_timeout = $scvgroup->idle_timeout / 60; $idle_msg_wait = $scvgroup->idle_msg_wait; $force_timeout = $scvgroup->force_timeout / 60; $force_msg_wait = $scvgroup->force_msg_wait; if(old('id') != null){ $enable = old('enable') != null ? "1" : "0"; $comment = old('comment'); $dayofweekarray = old('dayofweek'); $ena_dayofweek = old('ena_dayofweek') != null ? "1" : "0"; $hour = old('hour'); $ena_hour = old('ena_hour') != null ? "1" : "0"; $firefoxsave = old('firefoxsave') != null ? "1" : "0"; $copypaste = old('copypaste') != null ? "1" : "0"; $applist = old('applist'); $runmode = old('runmode'); $image = old('image'); $print = old('print'); $sanitize = old('sanitize'); $download = old('download'); $upload = old('upload') != null ? "1" : "0"; $maxlimit = old('maxlimit'); $scvpriority = old('scvpriority'); $firefoxprofile_id = old('firefoxprofile_id'); $shareprofile_id = old('shareprofile_id'); $org_id = old('organization_id'); $scvquality = old('scvquality'); $custom = old('custom'); $nemo_settings = old('nemo_settings'); $idle_timeout = old('idle_timeout'); $idle_msg_wait = old('idle_msg_wait'); $force_timeout = old('force_timeout'); $force_msg_wait = old('force_msg_wait'); $stz_flag = old('stz_flag'); $stz_dl_flag = old('custz_dl_flagstom'); $vck_flag = old('vck_flag'); $tck_flag = old('tck_flag'); $combined_flag = old('combined'); $dayofweeks = explode(",", $scvgroup->dayofweek); $nemo_settings = parseNemoSettings($scvgroup->nemo_settings); } if($enable == "1") $enable_msg = "checked"; if($ena_dayofweek == "1") $ena_dayofweek_msg = "checked"; if($ena_hour == "1") $ena_hour_msg = "checked"; if($firefoxsave) $firefoxsave_msg = "checked"; if($copypaste == "1") $copypaste_msg = "checked"; if($upload == "1") $upload_msg = "checked"; } ?>
<button type="button" onclick="location.href='/scvmanager/scvgroups'">戻る</button>
{{Form::model($scvgroup, ['url' => url("/scvmanager/scvgroups/$id"), 'method' => 'put'])}}
  <input type="hidden" name="id" value="{{$id}}">
  <div class="table-responsive">
  <table class="table table-condensed table-bordered">
    <tr>
      <td class="gray icon-td col-md-1"></td>
      <th align="left" class="gray col-md-2">グループ名</th>
      <td class="col-md-3">
        @if ($name === 'SCVTEMPLATE')
          <input type="hidden" name="name" value="{{$name}}">
          <span>{{$name}}</span>           
        @else
          <input type="text" name="name" value="{{$name}}">
          <span id="scvgroup-name"></span>           
        @endif
      </td>
      <td class="gray icon-td col-md-1"></td>
      <th align="left" class="gray col-md-2">組織</th>
      <td class="col-md-3">
        {{ $scvgroup->organization }}
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">有効</th>
      <td>
        <label class="check_area">
          <input type="checkbox" name="enable" value="enable" {{$enable_msg}}>
        </label>
      </td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">PRIORITY</th>
      <td>
        <select name="scvpriority">
        @if ($scvpriority=="HIGH")
          <option value="NORMAL">NORMAL</option>
          <option value="HIGH" selected>HIGH</option>
        @else
          <option value="NORMAL" selected>NORMAL</option>
          <option value="HIGH">HIGH</option>
        @endif
        </select>
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">曜日有効</th>
      <td>
        <label class="check_area">
          <input type="checkbox" name="ena_dayofweek" value="ena_dayofweek" {{$ena_dayofweek_msg}}>
        </label>
      </td>
      <td class="gray"></td>
      <th align="left" class="gray">許可曜日</th>
      <td class="weeks">
        <label style="margin-left:5px;" class="checkbox-inline">{{ Form::checkbox('all_chk', null, true) }}ALL</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[0]', 'SUN', in_array('SUN', $dayofweeks)) }}SUN</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[1]', 'MON', in_array('MON', $dayofweeks)) }}MON</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[2]', 'TUE', in_array('TUE', $dayofweeks)) }}TUE</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[3]', 'WED', in_array('WED', $dayofweeks)) }}WED</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[4]', 'THU', in_array('THU', $dayofweeks)) }}THU</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[5]', 'FRI', in_array('FRI', $dayofweeks)) }}FRI</label>
        <label class="checkbox-inline">{{ Form::checkbox('dayofweek[6]', 'SAT', in_array('SAT', $dayofweeks)) }}SAT</label>
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">時間有効</th>
      <td>
        <label class="check_area">
          <input type="checkbox" name="ena_hour" value="ena_hour" {{$ena_hour_msg}}>
        </label>
      </td>
      <td class="gray"></td>
      <th align="left" class="gray">許可時間</th>
      <td><input type="text" name="hour" size="20" value="{{$hour}}"></td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th align="left" class="gray">Firefox保存</th>
      <td>
        <label class="check_area">
          <input type="checkbox" name="firefoxsave" value="firefoxsave" {{$firefoxsave_msg}}>
        </label>
      </td>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th align="left" class="gray">コピー＆ペースト</th>
      <td>
        <select name="copypaste">
            <option value="0" @if($copypaste=="0") selected @endif>{{ $copypaste_options[0] }}</option>
            <option value="1" @if($copypaste=="1") selected @endif>{{ $copypaste_options[1] }}</option>
            <option value="2" @if($copypaste=="2") selected @endif>{{ $copypaste_options[2] }}</option>
            <option value="3" @if($copypaste=="3") selected @endif>{{ $copypaste_options[3] }}</option>
        </select>
        <span id="scvgroup-copypaste"></span>
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">ウィルスチェック</th>
      <td>
        <select name="vck_flag">
          @if(empty($availableOptions) || $availableOptions['vck'])
            <option value="0" @if($vck_flag=="0") selected @endif>無効</option>
            <option value="1" @if($vck_flag=="1") selected @endif>ウィルスチェック</option>
            <option value="2" @if($vck_flag=="2") selected @endif>ウィルスチェックダウンロード</option>
          @else
            <option value="0" selected disabled>利用不可</option>
          @endif
        </select>
      </td>
      <td class="gray"></td>
      <th align="left" class="gray">無害化オプション</th>
      <td>
        <select name="stz_flag">
          @if(empty($availableOptions) || $availableOptions['stz'])
            <option value="0" @if($stz_flag=="0") selected @endif>無効</option>
            <option value="1" @if($stz_flag=="1") selected @endif>SCVXSanitizer</option>
            @if($stz_flag=="2")
              <option value="2" @if($stz_flag=="2") selected @endif>FastSanitizer</option>
            @endif
            @if($stz_flag=="3")
              <option value="3" @if($stz_flag=="3") selected @endif>PDF無害化</option>
            @endif
            <label class="checkbox-inline" style="margin-left:5px;"><input type="checkbox" name="stz_dl_flag" value="1" @if($stz_dl_flag) checked  @endif>ダウンロード有効</label>
            <label class="checkbox-inline"><input type="checkbox" name="tck_stz_dl_flag" value="1" @if($tck_stz_dl_flag) checked  @endif>サンドボックス連携</label>
          @else
            <option value="0" selected disabled>利用不可</option>
          @endif
        </select>
      </td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">サンドボックスチェック</th>
      <td>
        <select name="tck_flag">
          @if(empty($availableOptions) || $availableOptions['tck'])
            <option value="0" @if($tck_flag=="0") selected @endif>無効</option>
            <option value="1" @if($tck_flag=="1") selected @endif>サンドボックスチェック</option>
            <option value="2" @if($tck_flag=="2") selected @endif>サンドボックスチェックダウンロード</option>
          @else
            <option value="0" selected disabled>利用不可</option>
          @endif
        </select>
      </td>
      <td class="gray"></td>
      <th align="left" class="gray">アップロード有効</th>
      <td>
        <label class="check_area">
          <input type="checkbox" name="upload" value="upload" {{$upload_msg}}>
        </label>
      </td>
    </tr>
    @if($enable_flow)
    <tr>
      <td class="gray"></td>
      <th class="gray">SCV Flow</th>
      <td>
        {{ Form::select('scv_flow', ['0' => '無効', '3' => '有効', '1' => 'アップロードのみ', '2' => 'ダウンロードのみ'])}}
      </td>
      <td class="gray"></td>
      <th align="left" class="gray"></th>
      <td></td>
    </tr>
    @endif
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">印刷有効</th>
      <td>
        <select name="print">
          <option value="0" @if($print=="0") selected @endif>無効</option>
          <option value="1" @if($print=="1") selected @endif>有効</option>
          @if($print=="2")
            <option value="2" @if($print=="2") selected @endif>SCVX印刷有効</option>
          @endif
          @if($print=="3")
            <option value="3" @if($print=="3") selected @endif>通常印刷 + SCVX印刷</option>
          @endif
        </select>
      </td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">ファイルマネージャ表示オプション</th>
      <td>
        <label style="margin-left:5px;" class="checkbox-inline">{{ Form::checkbox('nemo_settings[]', 'menubar', in_array('menubar', $nemo_settings, true)) }}メニューバー</label>
        <label class="checkbox-inline">{{ Form::checkbox('nemo_settings[]', 'sidebar', in_array('sidebar', $nemo_settings, true)) }}サイドバー</label>
      </td>
    </tr>
    <tr>
      <td rowspan="2" class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th rowspan="2" align="left" class="gray">アイドルタイムアウト</th>
      <td>タイムアウト : <input type="number" name="idle_timeout" min="0" max="10000" step="1" value="{{$idle_timeout}}"> 分
      <td rowspan="2" class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th rowspan="2" align="left" class="gray">強制タイムアウト</th>
      <td>タイムアウト : <input type="number" name="force_timeout" min="0" max="10000" step="1" value="{{$force_timeout}}"> 分
    </tr>
    <tr>
      <td>メッセージ : <input type="number" name="idle_msg_wait" min="0" max="10000" step="1" value="{{$idle_msg_wait}}"> 秒</td>
      <td>メッセージ : <input type="number" name="force_msg_wait" min="0" max="10000" step="1" value="{{$force_msg_wait}}"> 秒</td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">アプリケーション</th>
      <td>
        <input type="text" name="applist" size="20" value="{{$applist}}">
      </td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <!-- td>{{$applist}}</td -->
      <th align="left" class="gray">実行モード</th>
      <td>
        <select name="runmode">
        @if ($runmode=="SINGLE")
          <option value="SINGLE" selected>SINGLE</option>
          <option value="MULTI">MULTI</option>
        @else
          <option value="SINGLE">SINGLE</option>
          <option value="MULTI" selected>MULTI</option>
        @endif
        </select>
        <span id="run-mode"></span>
      </td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th class="gray">Firefox設定</th>
      <td>
        <select name="firefoxprofile_id">
          <option value="">設定しない</option>
          @foreach($firefoxprofs as $fp)
            @if($fp->id == $firefoxprofile_id)
              <option value="{{$fp->id}}" selected>{{$fp->name}}</option>
            @else
              <option value="{{$fp->id}}">{{$fp->name}}</option>
            @endif
          @endforeach
        </select>
      </td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th class="gray">共有フォルダ設定</th>
      <td>
        <select name="shareprofile_id">
        <option value="">設定しない</option>
        @foreach($shareprofiles as $sf)
          @if($sf->id == $shareprofile_id)
            <option value="{{$sf->id}}" selected>{{$sf->shname}}</option>
          @else
            <option value="{{$sf->id}}">{{$sf->shname}}</option>
          @endif
        @endforeach
        </select>
      </td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></td>
      <th align="left" class="gray">SCVX Chrome設定</th>
      <td>{{ Form::select('scvx_chrome_setting_id', $scvx_chromes->pluck('name', 'id')->prepend('設定しない', '0')) }}</td>
      <td class="gray"></td>
      <th class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">SCVイメージ</th>
      <td>
        <select name="image">
          <option>DEFAULT</option>
          @foreach($scvimages as $si)
            @if($si == $image)
              <option value="{{$si}}" selected>{{$si}}</option>
            @else
              <option value="{{$si}}">{{$si}}</option>
            @endif
          @endforeach
        </select>
      </td>
      <td class="gray"></td>
      <th class="gray"></th>
      <td></td>
    </tr>
    @if(App\Libs\ConfHelper::isMaxConnect() || App\Libs\ConfHelper::isDirectPrint())
      @if(App\Libs\ConfHelper::isMaxConnect())
      <td class="gray"><span class="scvx-icon"></span></td>
        <th align="left" class="gray">最大接続数
          <span class="glyphicon glyphicon-question-sign text-info" id="max_pop" data-toggle="popover" title="最大接続数" data-content="-1で無制限になります。">
        </th>
        <td><input type="number" name="maxlimit" value="{{$maxlimit}}" min="-1" step=1 max="99999"></td>
      @endif
      @if(App\Libs\ConfHelper::isDirectPrint())
      <tr>
        <td class="gray"><span class="scvx-icon"></span></td>
        <th align="left" class="gray">プリンタ設定</th>
        <td colspan="3">
          <textarea name="custom" rows="3" cols="80" warp="off">{!!$custom!!}</textarea>
        </td>
      </tr>
      @endif
    @endif
    <tr>
      <td class="gray"><span class="revobr-icon"></td>
        <th align="left" class="gray">RevoBrowser設定</th>
        <td>
          {{ Form::select('br_setting_id', $br_settings) }}
        </td>
      <td class="gray"><span class="revobr-icon"></span></td>
      <th align="right" class="gray">オフライン起動有効期限</th>
      <td>
        <input type="number" name="offline_expiration" value="{{$scvgroup->offline_expiration}}" step="0" min="0" max="240"/> 時間
        <span id="offline-cache-expiration"></span>
      </td>
    </tr>
    <tr>
      <td class="gray"><span class="revodt-icon"></span></td>
      <th align="left" class="gray">デスクトップ設定</th>
      <td>
        <div id="visionprof"></div>
        <input id="visionprof-del" type="button" value="削除">
        <input type="hidden" name="visionprofile_list" value="">
      </td>
      <td class="gray"></td>
      <th align="right" class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">備考</th>
      <td><input type="text" name="comment" size="20" value="{{$comment}}"></td>
      <td class="gray"></td>
      <th align="right" class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <td></td>
      <td colspan="5"><input type="submit" value="更新"></td>
    </tr>
  </table>
  </div>
{{Form::close()}}
@stop
@section('script')
<?php
$visionprofiles = \App\Visionprofile::all(); $select_texts = []; foreach ($visionprofiles as $visionprofile) $select_texts[] = $visionprofile->name; $js_arr = '[\'選択してください\',\'' . join('\',\'', $select_texts) . '\']'; $selected_indexes = []; $selected_texts = explode(',', $scvgroup->visionprofile_list); foreach ($selected_texts as $selected_text) foreach ($select_texts as $index => $select_text) if ($selected_text === $select_text) $selected_indexes[] = $index + 1; $js_arr2 = '[' . join(',', $selected_indexes) . ']'; ?>
<script src="{!! asset('js/tooltips.js') !!}"></script>
<script src="{!! asset('js/multiple-selectboxes.js') !!}"></script>
<script src="{!! asset('js/scvmanager/scvgroup.js') !!}"></script>
<script src="{!! asset('js/scvmanager/sync_firefoxprof.js') !!}"></script>
<script src="{!! asset('js/scvmanager/sync_shareprofile.js') !!}"></script>
<script src="{!! asset('js/scvmanager/sync_scvx_chrome_setting.js') !!}"></script>
<script>
  var flow_available = {{ $flow_available }};

  let msb = new MultipleSelectBoxes({
    location:              $('#visionprof'),
    removeButton:          $('#visionprof-del'),
    bindForm:              $('input[name=visionprofile_list]'),
    bindDelimitor:         ',',
    itemTexts:             {!! $js_arr !!},
    itemValues:            {!! $js_arr !!},
    initialSelectedItems:  {!! $js_arr2 !!},
    minShowingSelects:     1,
    maxShowingSelects:     3,
    allowDuplicate:        false,
    selectClassName:       'visionprof-selects',
    msgSelectsMaxExceeded: 'これ以上は選択できません',
    msgDuplicatedSelect:   '項目の重複はできません',
    errorAlert:            false
  });
</script>
@stop
