<!-- scv/resources/views/scvgroups/index.blade.php -->
@extends('layout.default')
@section('content')


<div class="page-header">
  <h3>グループ管理</h3>
</div>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@else
  <p class="text-info">グループにセキュリティポリシーを設定してそれを各ユーザに割り当てます。</p>
@endif

<button onclick="location.href='{{URL::to('/scvmanager/scvgroups/create')}}'">作成</button>
<button onclick="location.href='/scvmanager/scvgroups/csv'">一括登録</button>
<button onclick="location.href='/scvmanager/firefoxprof'">Firefox設定</button>
<button onclick="location.href='/scvmanager/scvx_chrome_settings'">SCVX Chrome設定</button>
<button onclick="location.href='/scvmanager/share'">共有フォルダ設定</button>
@if(App\Libs\UserHelper::isAdmin())
  <button onclick="location.href='/scvmanager/br_settings'">RevoBrowser設定</button>
  <button onclick="location.href='/scvmanager/visionprof'">デスクトップ設定</button>
  <button onclick="location.href='/scvmanager/vpn_settings'">VPN設定</button>
  <button onclick="location.href='/scvmanager/proxy_settings'">Proxy設定</button>
@endif

<div class="text-center">{!! $scvgroups->render() !!}</div>

<div class="table-responsive">
  <table class="table table-condensed table-bordered table-striped">
  <thead>
    <tr>
      <th align="left">有効</th>
      <th align="left">組織</th>
      <th align="left">グループ</th>
      <th align="left">曜日</th>
      <th align="left">時間</th>
      <th align="left">保存</th>
      <th align="left">コピー</th>
      <th align="left">実行</th>
      <th align="left">イメージ</th>
      <th align="left">Firefox</th>
      <th align="left">SCVX Chrome</th>
      <th align="left">共有</th>
      <th align="left">備考</th>
    </tr>
  </thead>
  <tbody>
<?php
 require_once(app_path().'/Libs/setIcon.php'); ?>
  @foreach($scvgroups as $scvgroup)
    <?php
 $targeturl="/scvmanager/scvgroups/" . $scvgroup->id; $enable_icon = seticon($scvgroup->enable); $ena_dayofweek_icon = seticon($scvgroup->ena_dayofweek); $ena_hour_icon = seticon($scvgroup->ena_hour); $firefoxsave_icon = seticon($scvgroup->firefoxsave); $isAdmin = Auth::check() && Auth::user()->organization_id == "1"; if($scvgroup->profname != null){ $link = '<a href="/scvmanager/firefoxprof/'.$scvgroup->firefoxprofile_id.'">'.$scvgroup->profname.'</a>'; }else{ $link = "なし"; } if($scvgroup->scvxchromename){ $scvx_chrome_link = '<a href="/scvmanager/scvx_chrome_settings/'.$scvgroup->scvx_chrome_setting_id.'">'.$scvgroup->scvxchromename.'</a>'; }else{ $scvx_chrome_link = "なし"; } if($scvgroup->shname != null){ $share_link = '<a href="/scvmanager/share/'.$scvgroup->shareprofile_id.'">'.$scvgroup->shname.'</a>'; }else{ $share_link = "なし"; } ?>
    <tr>
      <td align="center">{!! $enable_icon !!}</td>
      <td align="left">{{$scvgroup->orgname}}</td>
      <td align="left"  ><a href="{{URL::to($targeturl)}}">{{$scvgroup->name}}</a></td>
      <td align="center">{!! $ena_dayofweek_icon !!}</td>
      <td align="center">{!! $ena_hour_icon !!}</td>
      <td align="center">{!! $firefoxsave_icon !!}</td>
      <td align="center">{{ $scvgroup->copypaste_view }}</td>
      <td align="left"  >{{$scvgroup->runmode}}</td>
      <td align="left"  >{{$scvgroup->image}}</td>
      <td>{!! $link !!}</td>
      <td>{!! $scvx_chrome_link !!}</td>
      <td>{!! $share_link !!}</td>
      <td align="left"  >{{$scvgroup->comment}}</td>
    </tr>
  @endforeach
  </tbody>
  </table>
</div>
<div class="text-center">{!! $scvgroups->render() !!}</div>
@stop
