<!-- scv/resources/views/scvgroups/show.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>グループ詳細</h3>
</div>
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<?php
 $id = $scvgroup->id; $name = $scvgroup->name; $enable = $scvgroup->enable; $comment = $scvgroup->comment; $dayofweek = $scvgroup->dayofweek ?:"なし"; $hour = $scvgroup->hour; $ena_dayofweek = $scvgroup->ena_dayofweek; $ena_hour = $scvgroup->ena_hour; $firefoxsave = $scvgroup->firefoxsave; $copypaste = $scvgroup->copypaste; $applist = $scvgroup->applist; $runmode = $scvgroup->runmode; $image = $scvgroup->image; $print = $scvgroup->print; $sanitize = $scvgroup->sanitize; $download = (int)$scvgroup->download; $upload = $scvgroup->upload; $maxlimit = $scvgroup->maxlimit == -1 ?"無制限":$scvgroup->maxlimit; $scvpriority = $scvgroup->scvpriority; $scvquality = $scvgroup->scvquality; $profid = $scvgroup->firefoxprofile_id; $profname = $scvgroup->profname ?: "なし"; $scvx_chrome_id = $scvgroup->scvx_chrome_setting_id; $scvx_chrome_name= $scvgroup->scvx_chrome_name ?: "なし"; $shid = $scvgroup->shareprofile_id; $shname = $scvgroup->shname ? : "なし"; $ieprof_id = $scvgroup->ieprofile_id; $ieprof_name = $scvgroup->ieprof_name ?: "なし"; $br_setting_id = $scvgroup->br_setting_id; $br_setting_name= $scvgroup->br_setting_name ?: "なし"; $visionprofile_list = $scvgroup->visionprofile_list ? : "なし"; $dtnames = \App\Libs\Utils::split_by_comma($visionprofile_list); $created_at = $scvgroup->created_at; $updated_at = $scvgroup->updated_at; $updurl="/scvmanager/scvgroups/".$id."/edit"; $custom = urldecode(nl2br($scvgroup->custom)); $nemo_settings = $scvgroup->nemo_settings; $idle_timeout = $scvgroup->idle_timeout / 60; $force_timeout = $scvgroup->force_timeout / 60; $offline_expiration = $scvgroup->offline_expiration; $isAdmin = Auth::check() && Auth::user()->organization_id == "1"; if($profid == 0){ $proflink = "なし"; }else{ if($isAdmin){ $proflink = '<a href="/scvmanager/firefoxprof/'.$profid.'">'.$profname.'</a>'; }else{ $proflink = $profname; } } if($scvx_chrome_id == 0){ $scvx_chrome_link = "なし"; }else{ if($isAdmin){ $scvx_chrome_link = "<a  href='/scvmanager/scvx_chrome_settings/$scvx_chrome_id'>$scvx_chrome_name</a>"; }else{ $scvx_chrome_link = $scvx_chrome_name; } } if($shid == 0){ $sharelink = "なし"; }else{ if($isAdmin){ $sharelink = '<a href="/scvmanager/share/'.$shid.'">'.$shname.'</a>'; }else{ $sharelink = $shname; } } if($ieprof_id == 0){ $ieprof_link = "なし"; }else{ if($isAdmin){ $ieprof_link = "<a  href='/scvmanager/ieprof/$ieprof_id'>$ieprof_name</a>"; }else{ $ieprof_link = $ieprof_name; } } if($br_setting_id == 0){ $br_setting_link = "なし"; }else{ if($isAdmin){ $br_setting_link = "<a  href='/scvmanager/br_settings/$br_setting_id'>$br_setting_name</a>"; }else{ $br_setting_link = $br_setting_name; } } require_once(app_path().'/Libs/setIcon.php'); $enable_icon = seticon($enable); $ena_dayofweek_icon = seticon($ena_dayofweek); $ena_hour_icon = seticon($ena_hour); $firefoxsave_icon = seticon($firefoxsave); $upload_icon = seticon($upload); $idle_timeout = $idle_timeout == 0 ? seticon(0) : $idle_timeout." 分"; $force_timeout = $force_timeout == 0 ? seticon(0) : $force_timeout." 分"; $nemo_menubar = seticon($nemo_settings & 0x01); $nemo_sidebar = seticon($nemo_settings & 0x02); $offline_expiration = $offline_expiration == 0 ? seticon(0) : $offline_expiration." 時間"; switch ($print) { case 0: $print_msg = "無効";break; case 1: $print_msg = "有効";break; case 2: $print_msg = "SCVX印刷有効";break; case 3: $print_msg = "通常印刷 + SCVX印刷";break; } $sanitize_str = "無し"; $vck_str = "無し"; $tck_str = "無し"; if($sanitize & 0x10) $sanitize_str = "FastSanitizer"; if($sanitize & 0x20) $sanitize_str = "PDF無害化"; if($sanitize & 0x40) $sanitize_str = "SCVXSanitizer"; if($sanitize & 0x80) $vck_str = "ウィルスチェック"; if($sanitize & 0x100) $tck_str = "サンドボックスチェック"; if($sanitize & 0x80 && $download & 0x02) $vck_str = "ウィルスチェックダウンロード"; if($sanitize & 0x100 && $download & 0x04) $tck_str = "サンドボックスチェックダウンロード"; $combined_str = $download & 0x10 ? "(サンドボックス連携)" : ""; switch($scvgroup->scv_flow){ case 1: $flow_str = 'アップロードのみ'; break; case 2: $flow_str = 'ダウンロードのみ'; break; case 3: $flow_str = '有効'; break; default: $flow_str = '無効'; } if (isset($errmsg)){ echo $errmsg; }else{ echo '<p>&nbsp;</p>'; } ?>
<form action="/scvmanager/scvgroups/{{$id}}" method="POST">
<input type="hidden" name="_token" value="{{csrf_token()}}">
<input type="hidden" name="id" value="{{$id}}">
<input type="hidden" name="_method" value="DELETE">
<button type="button" onclick="location.href='/scvmanager/scvgroups'">戻る</button>
@if ($name!='DEFAULT' and $name!='ADMIN')
  <button type="button" onclick="location.href='{{$updurl}}'">{{$name}}を編集</button>
  <input type="submit" name="remove" onclick="return check();" value="削除">
@endif
  <div class="table-responsive">
  <table class="table table-condensed table-bordered">
  <tbody>
    <tr>
      <td class="gray icon-td col-md-1"></td>
      <th align="left" class="gray col-md-2">グループ</th>
      <td class="col-md-3">{{$name}}</td>
      <td class="gray icon-td col-md-1"></td>
      <th align="left" class="gray col-md-2">組織</th>
      <td class="col-md-3">{{$scvgroup->organization}}</td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">有効</th>
      <td>{!!$enable_icon!!}</td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">PRIORITY</th>
      <td>{{$scvpriority}}</td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">曜日有効</span></th>
      <td>{!!$ena_dayofweek_icon!!}</td>
      <td class="gray"></td>
      <th align="left" class="gray">許可曜日</span></th>
      <td>{{$dayofweek}}</td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">時間有効</th>
      <td>{!!$ena_hour_icon!!}</td>
      <td class="gray"></td>
      <th align="left" class="gray">許可時間</th>
      <td>{{$hour}}</td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th align="left" class="gray">Firefox保存有効</th>
      <td>{!!$firefoxsave_icon!!}</td>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th align="left" class="gray">コピー＆ペースト</th>
      <td>{{ $scvgroup->copypaste_view }}</td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">ウィルスチェック</th>
      <td>{{$vck_str}}</td>
      <td class="gray"></td>
      <th align="left" class="gray">無害化オプション</th>
      <td>{{$sanitize_str}} @if($download&0x01) + ダウンロード @endif {{$combined_str}}</td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">サンドボックスチェック</th>
      <td>{{$tck_str}}</td>
      <td class="gray"></td>
      <th align="left" class="gray">アップロード有効</th>
      <td>{!!$upload_icon!!}</td>
    </tr>
    @if($enable_flow)
    <tr>
      <td class="gray"></td>
      <th class="gray">SCV Flow</th>
      <td>{{$flow_str}}</td>
      <td class="gray"></td>
      <th align="left" class="gray"></th>
      <td></td>
    </tr>
    @endif
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">印刷有効</th>
      <td>{{$print_msg}}</td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">ファイルマネージャ表示オプション</th>
      <td>メニューバー：{!!$nemo_menubar!!} サイドバー：{!!$nemo_sidebar!!}</td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th align="left" class="gray">アイドルタイムアウト</th>
      <td>{!!$idle_timeout!!}</td>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th align="left" class="gray">強制タイムアウト</th>
      <td>{!!$force_timeout!!}</td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">アプリケーション</th>
      <td>{{$applist}}</td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">実行モード</th>
      <td>{{$runmode}}</td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
      <th class="gray">Firefox設定</th>
      <td>{!!$proflink!!}</td>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">共有フォルダ設定</th>
      <td>{!!$sharelink!!}</td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th class="gray">SCVX Chrome設定</th>
      <td>{!! $scvx_chrome_link !!}</td>
      <td class="gray"></td>
      <th class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <td class="gray"><span class="scvx-icon"></span></td>
      <th align="left" class="gray">SCVイメージ</th>
      <td>{{$image}}</td>
      <td class="gray"></td>
      <th class="gray"></th>
      <td></td>
    </tr>
    @if(App\Libs\ConfHelper::isMaxConnect() || App\Libs\ConfHelper::isDirectPrint())
      @if(App\Libs\ConfHelper::isMaxConnect())
        <td class="gray"><span class="scvx-icon"></span></td>
        <th align="left" class="gray">最大接続数</th>
        <td>{{$maxlimit}}</td>
      @endif
      @if(App\Libs\ConfHelper::isDirectPrint())
      <tr>
        <td class="gray"></td>
        <th align="left" class="gray">プリンタ設定</th>
        <td colspan="3">{!!$custom!!}</td>
      </tr>
      @endif
    @endif
    <tr>
      <td class="gray"><span class="revobr-icon"></span></td>
      <th align="right" class="gray">RevoBrowser設定</th>
      <td>{!! $br_setting_link !!}</td>
      <td class="gray"><span class="revobr-icon"></span></td>
      <th align="right" class="gray">オフライン起動有効期限</th>
      <td>{!! $offline_expiration !!}</td>
    </tr>
    <tr>
      <td class="gray"><span class="revodt-icon"></span></td>
      <th align="left" class="gray">デスクトップ設定</th>
      <td>
        @if ($visionprofile_list === 'なし')
          なし
        @else
          @foreach ($dtnames as $dtname)
            @if ($dtname !== $dtnames[0]) , @endif
            <?php $dtid = \App\Visionprofile::where('name', $dtname)->first()->id ?>
            <a href="/scvmanager/visionprof/{{ $dtid }}">{{ $dtname }}</a>
          @endforeach
        @endif
      </td>
      <td class="gray"></td>
      <th align="right" class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">備考</th>
      <td>{{$comment}}</td>
      <td class="gray"></td>
      <td class="gray"></td>
      <td></td>
    </tr>
    <tr>
      <td class="gray"></td>
      <th align="left" class="gray">登録日</th>
      <td>{{$created_at}}</td>
      <td class="gray"></td>
      <th align="left" class="gray">更新日</th>
      <td>{{$updated_at}}</td>
    </tr>
  </tbody>
  </table>
  </div>

</form>
@endsection
@section('script')
<script type="text/javascript">
  function check(){
      if(confirm("{{$name}}を削除しますか？")){
        return true;
      }else{
        return false;
      }
  }
</script>
@endsection
