<!-- scv/resources/views/scvlogin/index.blade.php -->
<!doctype html>
<html lang="ja">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="cache-control" content="no-cache" />
        <meta http-equiv="expires" content="0" />
        <meta name="description" content="Secure Console Vitrual">
        <meta name="author" content="tnakamura@jscom.co.jp">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title>SCV Login</title>
        <link href="{!! asset('css/bootstrap.min.css') !!}" rel="stylesheet">
        <style>

/*
 * General styles
 */
body, html {
    height: 100%;
    background-repeat: no-repeat;
    background-color: rgb(255, 255, 255);
}

.card-container.card {
    max-width: 320px;
    padding: 20px 30px;
}

.btn {
    font-weight: 700;
    height: 36px;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    cursor: default;
}

/*
 * Card component
 */
.card {
    background-color: rgb(67, 78, 83);
    /* just in case there no content*/
    padding: 20px 25px;
    margin: 0 auto 25px;
    /* shadows and rounded borders */
    -moz-border-radius: 2px;
    -webkit-border-radius: 2px;
    border-radius: 2px;
    -moz-box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.3);
    -webkit-box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.3);
    box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.3);
}

.profile-img-card {
    width: 96px;
    height: 96px;
    margin: 0 auto;
    margin-bottom: 10px;
    display: block;
    -moz-border-radius: 50%;
    -webkit-border-radius: 50%;
    border-radius: 50%;
}

/*
 * Form styles
 */
.form-signin input[name=user],
.form-signin input[name=password] {
    direction: ltr;
    height: 40px;
    font-size: 16px;
}

.form-signin input[type=password],
.form-signin input[type=tel],
.form-signin input[type=text],
.form-signin button {
    width: 100%;
    display: block;
    margin-bottom: 10px;
    z-index: 1;
    position: relative;
    -moz-box-sizing: border-box;
    -webkit-box-sizing: border-box;
    box-sizing: border-box;
}

.form-signin .form-control:focus {
    border-color: rgb(104, 145, 162);
    outline: 0;
    -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075),0 0 8px rgb(104, 145, 162);
    box-shadow: inset 0 1px 1px rgba(0,0,0,.075),0 0 8px rgb(104, 145, 162);
}

.btn.btn-signin {
    background-color: rgb(1, 123, 205);
    margin-top: 25px;
    padding: 0px;
    font-weight: 700;
    font-size: 14px;
    height: 36px;
    -o-transition: all 0.1s;
    -moz-transition: all 0.1s;
    -webkit-transition: all 0.1s;
    transition: all 0.1s;
    border-radius: 4px;
}

.btn.btn-signin:hover,
.btn.btn-signin:active,
.btn.btn-signin:focus {
    background-color: rgb(0, 0, 0);
}

.forgot-password {
    color: rgb(104, 145, 162);
}

.forgot-password:hover,
.forgot-password:active,
.forgot-password:focus{
    color: rgb(12, 97, 33);
}
        </style>
    </head>
    <body>
    scvlogin_faze: {{ Session::get('scvlogin_faze') }}
    scvlogin_user: {{ Session::get('scvlogin_user') }}
        <div class="container">
            <div style="text-align: center; margin-top: 30px; margin-bottom: 10px; !important; font-size: 14px">
                @if (Session::get('scvlogin_faze') === 'scvxlocal')
                    {{-- ユーザ名＆パスワード認証を行うとき --}}

                    SCV<span style="color: red">X</span>にログイン<br>
                    @if ($errors->any())
                        <br>
                        <span style="color: #ff2200">
                            @foreach ($errors->all() as $error)
                                <span>{{ $error }}</span><br>
                            @endforeach
                        </span>
                    @endif

                @elseif (Session::get('scvlogin_faze') === 'totp')
                    {{-- ワンタイムパスワード認証を行うとき --}}

                    @if (!$errors->any())
                        ようこそ、{{ $user }}さん。ワンタイムパスワードを入力すると認証を完了します。
                    @else
                        <span style="color: #ff2200">
                            @foreach ($errors->all() as $error)
                                <span>{{ $error }}</span><br>
                            @endforeach
                        </span>
                    @endif
                @endif
            </div>
            <div class="card card-container" style="margin-top: 15px;">
                <img id="profile-img" class="profile-img-card" src="{!! asset('images/shachi.png') !!}" />
                <form class="form-signin" method="post" action="/scvlogin">
                    @if (Session::get('scvlogin_faze') === 'scvxlocal')
                        {{-- ユーザ名＆パスワード認証を行うとき --}}

                        <input type="text" name="user" class="form-control" placeholder="ユーザ名" required autofocus>
                        <input type="password" name="password" class="form-control" placeholder="パスワード" required>

                    @elseif (Session::get('scvlogin_faze') === 'totp')
                        {{-- ワンタイムパスワード認証を行うとき --}}

                        <input type="tel" name="password" class="form-control" placeholder="6桁のパスワード" required>
                    @endif
                    {{ csrf_field() }}
                    <button class="btn btn-lg btn-primary btn-block btn-signin" type="submit">接続</button>
                </form>
            </div><!-- /card-container -->
        </div><!-- /container -->
        <div style="text-align: center; margin-top: 10px;">{{ config('scv.copyright') }}</div>
        <script src="{!! asset('js/jquery-1.11.3.min.js') !!}"></script>
        <script src="{!! asset('js/bootstrap.min.js') !!}"></script>
    </body>
</html>
