<!-- scv/resources/views/scvusers/create.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>ユーザ作成</h3>
</div>

@if (Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@else
  @if (App\Libs\ADHelper::isScvxKerberos())
    <p><span style="color:red">AD連携/Kerberos認証モードです。ユーザ名を入力してください。</span></p>
  @elseif (App\Libs\ADHelper::isScvxLdap())
    <p><span style="color:red">LDAP認証モードです。ユーザ名を入力してください。</span></p>
  @elseif (App\Libs\ADHelper::isScvxSaml())
    <p><span style="color:red">SAML認証モードです。ユーザ名を入力してください。</span></p>
  @else
    <p class="text-info">ユーザ名とパスワードを入力してください。</p>
  @endif
@endif

<button type="button" onclick="location.href='{{URL::to('/scvmanager/scvusers')}}'">戻る</button>
<form action="{{URL::to('/scvmanager/scvusers')}}" method="POST">
  {{ Form::token() }}
  {{ Form::hidden('organization', $organization) }}
  <div class="table-responsive">
    <table class="table table-condensed table-bordered two-stages-layout">
      <tr>
        <th>SCVユーザ名</th>
        <td>
          {{ Form::text('name', null, ['autofocus']) }}
          <span id="scvuser-name"></span>
        </td>
        <th>グループ名</th>
        <td>
          <select name="org_group">
          @foreach($scvgroups as $scvgroup)
            <option value="{{$scvgroup->org_group}}" @if(Input::old('org_group') == $scvgroup->org_group) selected @endif>
              {{ $scvgroup->display_name }}
            </option>
          @endforeach
          </select>
        </td>
      </tr>
      <tr>
        @if (!App\Libs\ConfHelper::usingPassword())
          <th>パスワード</th>
          <td>登録不要</td>
        @else
          <th>パスワード</th>
          <td>
            {{ Form::password('password') }}
            <span id="scvuser-password"></span>
          </td>
        @endif
        @if (!App\Libs\ConfHelper::usingPassword())
          <th>パスワード確認</th>
          <td>登録不要</td>
        @else
          <th>パスワード確認</th>
          <td>
            {{ Form::password('password_confirmation') }}
            <span id="scvuser-password-confirmation"></span>
          </td>
        @endif
      </tr>
      <tr>
        <th>社員番号</th>
        <td>
          {{ Form::text('employee_id', '', ['placeholder' => '<英数字を入力できます>']) }}
          <span id="scvuser-flows"></span>
        </td>
        <th>氏名</th>
        <td>{{ Form::text('jpname') }}</td>
      </tr>
      <tr>
        <th>部署</th>
        <td>{{ Form::text('department', null, ['placeholder' => '営業部']) }}</td>
        <th>役職</th>
        <td>{{ Form::text('post', null, ['placeholder' => '部長']) }}</td>
      </tr>
      <tr>
        <th>任意データ1</th>
        <td>{{ Form::text('custom_data1') }}</td>
        <th>任意データ2</th>
        <td>{{ Form::text('custom_data2') }}</td>
      </tr>
      <tr>
        <th>任意データ3</th>
        <td>{{ Form::text('custom_data3') }}</td>
        <th>備考</th>
        <td>{{ Form::text('comment') }}</td>
      </tr>
      <tr>
        <th>Eメール</th>
        <td>
          {{ Form::text('email') }}
          <span id="scvuser-email"></span>
        </td>
        @if ($flow_available)
          <th>SCVFlowの承認権限</th>
          <td>{{ Form::checkbox('privilege') }}</td>
        @else
          <th></th>
          <td></td>
        @endif
      </tr>
      @if ($flow_available)
        <tr>
          <th></th>
          <td></td>
          <th>SCVFlowの承認グループ</th>
          <td>
            {{ Form::text('flow_group') }}
            <span id="flow-group"></span>
          </td>
        </tr>
      @endif
      <tr>
        <th></th>
        <td colspan="3">
          <input type="submit" name="submit" value="登録">
        </td>
      </tr>
    </table>
  </div>
</form>
@stop
@section('script')
{{-- FLOW有効時、Emailにアスタリスクをつけるためのフラグ --}}
<script> var flow_available = {{ App\Libs\ConfHelper::scvconf('SCV_FLOW') }}; </script>
<script src="{!! asset('js/tooltips.js') !!}"></script>
@stop