<!-- scv/resources/views/scvusers/edit.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>ユーザ変更</h3>
</div>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@else
  <p class="text-info">以下の項目を変更できます。</p>
@endif
<?php
 if (isset($scvuser)) { $organization = $scvuser->organization; $name = $scvuser->name; $groupname = $scvuser->groupname; $email = $scvuser->email; $comment = $scvuser->comment; $employee_id = $scvuser->employee_id; $jpname = $scvuser->jpname; $department = $scvuser->department; $post = $scvuser->post; $custom_data1 = $scvuser->custom_data1; $custom_data2 = $scvuser->custom_data2; $custom_data3 = $scvuser->custom_data3; $flow_group = $scvuser->flow_group; $privilege = $scvuser->privilege; $url = '/scvmanager/scvusers/' . $scvuser->id; } $email = Input::old('email') ?: $email; $comment = Input::old('comment') ?: $comment; ?>
<button type="button" onclick="location.href='{{ URL::to($url) }}'">戻る</button>
<form action="{{$url}}" method="POST">
  <input type="hidden" name="_token" value="{{ csrf_token() }}">
  <input type="hidden" name="organization" value="{{ $organization }}">
  <input type="hidden" name="name" value="{{ $name }}">
  <input type="hidden" name="_method" value="PUT">

  <div class="table-responsive">
  <table class="table table-condensed table-bordered">
    <tr>
      <th>SCVユーザ名</th>
      <td>{{ $name }}</td>
      <th>グループ名</th>
      <td>
      @if($name == "scvtemplate")
        {{$scvuser->groupname}}
        <input type="hidden" name="group" value="SCVTEMPLATE">
      @else
        <select name="group">
          @foreach ($scvgroups as $scvgroup)
            <option value="{{ $scvgroup->name }}" @if(Input::old('group') == $scvgroup->name || $scvuser->groupid == $scvgroup->id) selected @endif>
              {{ $scvgroup->name }}
            </option>
          @endforeach
        </select>
      @endif
      </td>
    </tr>
    <tr>
      <th>社員番号</th>
      <td>
        <input type="text" name="employee_id" size="20" value="{{$employee_id}}">
        <span id="scvuser-flows"></span>
      </td>
      <th>氏名</th>
      <td><input type="text" name="jpname" size="20" value="{{$jpname}}"></td>
    </tr>
    <tr>
      <th>部署</th>
      <td>
        <input type="text" name="department" size="20" value="{{$department}}">
      </td> 
      <th>役職</th>
      <td>
        <input type="text" name="post" size="20" value="{{$post}}">
      </td>
    </tr>
    <tr>
      <th>任意データ1</th>
      <td>
        <input type="text" name="custom_data1" size="20" value="{{$custom_data1}}">
      </td> 
      <th>任意データ2</th>
      <td>
        <input type="text" name="custom_data2" size="20" value="{{$custom_data2}}">
      </td>
    </tr>
    <tr>
      <th>任意データ3</th>
      <td>
        <input type="text" name="custom_data3" size="20" value="{{$custom_data3}}">
      </td>
      <th>備考</th>
      <td>
        <input type="text" name="comment" size="20" value="{{$comment}}">
      </td>
    </tr>
    <tr>
      <th>Eメール</th>
      <td>
        <input type="email" name="email" size="20" value="{{$email}}">
        <span id="scvuser-email"></span>
      </td>
      @if ($flow_available)
        <th>SCVFlowの承認権限</th>
        <td>
          <input type="checkbox" name="privilege" value="1" class="checkbox-inline" @if (Input::old('privilege', $privilege)) checked @endif>
        </td>
      @else
        <th></th>
        <td></td>
      @endif
    </tr>
    @if ($flow_available)
      <tr>
        <th></th>
        <td></td>
        <th>SCVFlowの承認グループ</th>
        <td>
          {{ Form::text('flow_group', $flow_group) }}
          <span id="flow-group"></span>
        </td>
      </tr>
    @endif
    <tr>
      <th></th>
      <td colspan="3">
        <input type="submit" name="submit" value="更新">
      </td>
    </tr>
  </table>
  </div>
</form>
@stop
@section('script')
{{-- FLOW有効時、Emailにアスタリスクをつけるためのフラグ --}}
<script> var flow_available = {{ $flow_available }}; </script>
<script src="{!! asset('js/tooltips.js') !!}"></script>
@stop