<!-- scv/resources/views/scvusers/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
<h3>ユーザ管理</h3>
</div>

@if (App\Libs\ADHelper::isScvxKerberos())
  <p style="color:red">AD連携/Kerberos認証モードです。登録ユーザだけがSCVを利用することができます。</p>
@elseif (App\Libs\ADHelper::isScvxLdap())
  <p style="color:red">LDAP認証モードです。登録ユーザだけがSCVを利用することができます。</p>
@else
  <p class="text-info">登録ユーザだけがSCVXを利用することができます。</p>
@endif

<div style="max-width:100px; min-width:20px; float:left; padding-right:5px;">
  <button onclick="location.href='{{URL::to('/scvmanager/scvusers/create')}}'">作成</button>
</div>
<div style="float:left; padding-right:5px;">
    <button onclick="location.href='{{URL::to('/scvmanager/batch')}}'">一括登録</button>
</div>

@if(App\Libs\ADHelper::canLdapSettings())
  <div style="float:left; padding-right:5px;">
    <button onclick="location.href='{{URL::to('/scvmanager/scvusers/ldaps')}}'">LDAP管理</button>
  </div>
@endif

<form style="float:left" action="{{URL::to('/scvmanager/search')}}" method="get">
  <input type="text" name="word" placeholder="検索ワード">
  <input type="submit" value="検索">
</form>

<div style="clear:both"></div>

<div class="text-center">{!! $scvusers->render() !!}</div>
<form action="{{URL::to('/scvmanager/scvuserdel')}}" method="POST">
<input type="hidden" name="_token" value="{{csrf_token()}}">

<div class="table-responsive">
<table class="table table-condensed table-striped table-bordered">
  <thead>
    <tr>
      <th align="left">ID</th>
      <th align="left">ユーザ</th>
      <th align="left">氏名</th>
      @if(Auth::user()->organization_id == "1")
      <th align="left">組織</th>
      @endif
      <th align="left">グループ</th>
      <th align="left">email</th>
      <th align="left">備考</th>
      <th align="left">登録日</th>
      <th align="left">更新日</th>
    </tr>
  </thead>
  <tbody>
  @foreach($scvusers as $scvuser)
    <tr>
      <td>{{$scvuser->id}}</td>
      <?php $targeturl1="/scvmanager/scvusers/" . $scvuser->id ?>
      <td><a href="{{URL::to($targeturl1)}}">{{$scvuser->name}}</a></td>
      <td><a href="{{URL::to($targeturl1)}}">{{$scvuser->jpname}}</a></td>
      @if(Auth::user()->organization_id == "1")
      <?php $org_url="/scvmanager/organization/".$scvuser->org_name; ?>
      <td><a href="{{URL::to($org_url)}}">{{$scvuser->org_name}}</a></td>
      @endif
      <?php $targeturl2="/scvmanager/scvgroups/" . $scvuser->groupid ?>
      <td><a href="{{URL::to($targeturl2)}}">{{$scvuser->groupname}}</a></td>
      <td>{{$scvuser->email}}</td>
      <td>{{$scvuser->comment}}</td>
      <td>{{$scvuser->created_at}}</td>
      <td>{{$scvuser->updated_at}}</td>
    </tr>
  @endforeach
  </tbody>
</table>
<div class="text-center">{!! $scvusers->render() !!}</div>
</div>

</form>

@endsection

