<!-- scv/resources/views/scvusers/ldaps/edit.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>
  @if ($ldap->id)
    LDAP設定変更
  @else
    LDAP設定作成
  @endif
  </h3>
</div>
@if(Session::has('err'))
  <p style="color:red;">{{session('err')}}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

@if ($ldap->id)
  <button onclick="location.href='{{URL::to('/scvmanager/scvusers/ldaps/' . $ldap->id)}}'">戻る</button>
  {{Form::open(['url' => '/scvmanager/scvusers/ldaps/'. $ldap->id, 'method' => 'put'])}}
@else
  <button onclick="location.href='{{URL::to('/scvmanager/scvusers/ldaps')}}'">戻る</button>
  {{Form::open(['url' => '/scvmanager/scvusers/ldaps', 'method' => 'post'])}}
@endif
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <div class="table-responsive">
    <table class="table table-condensed table-bordered">
      <tr>
        <th align="left" class="gray">設定名</th>
        <td colspan="3">
          <input type="text" name="name" size="20" value="{{old('name', $ldap->name)}}">
          <span id="ldapsetting-name"></span>
        </td>
      </tr>
      <tr>
        <th align="left" class="gray">ホスト</th>
        <td>
          <input type="text" name="host" size="20" value="{{old('host', $ldap->host)}}">
          <span id="ldapsetting-host"></span>
        </td>
        <th align="left" class="gray">ポート</th>
        <td><input type="number" min="0" max="65535" name="port" size="20" value="{{old('port', $ldap->port)}}"></td>
      </tr>
      <tr>
        <th align="left" class="gray">アカウント</th>
        <td><input type="text" name="user" size="20" value="{{old('user', $ldap->user)}}" style="width:100%"></td>
        <th align="left" class="gray">パスワード</th>
        <td><input type="password" name="password" size="20" value="{{old('password', $ldap->password)}}"></td>
      </tr>
      <tr>
        <th align="left" class="gray">ベースDN</th>
        <td>
          <input type="text" name="dn" size="20" value="{{old('dn', $ldap->dn)}}"style="width:100%;">
          <span id="ldapsetting-dn"></span>
        </td>
        <th align="left" class="gray">組織</th>
        <td>
          <select id='select-org' name="organization_id">
          @foreach ($orgs as $org)
            <option value="{{$org->id}}"
              @if (Input::old('orgid', $ldap->organization_id) == $org->id) selected
              @elseif (!in_array($org->id, $selectableOrgs)) disabled
              @endif
            >{{$org->name}}</option>
          @endforeach
          </select>
        </td>
      </tr>
      <tr>
        <th align="left" class="gray">フィルター</th>
        <td>
          <input type="text" name="filter" size="20" value="{{old('filter', $ldap->filter)}}" style="width:90%;">
          <span id="ldapsetting-filter"></span>
        </td>
        <th align="left" class="gray">登録時所属グループ</th>
        <td>
          <select id='select-group' name="groupid" data-old="{{old('groupid', $ldap->groupid)}}">
          @foreach ($groups as $group)
            <option value="{{$group->id}}" data-orgid="{{$group->organization_id}}">{{$group->name}}</option>
          @endforeach
          </select>
        </td>
      </tr>
      <tr>
        <th align="left" class="gray">ユーザ名属性</th>
        <td>
          <input type="text" name="username_attr" size="20" value="{{old('username_attr', $ldap->username_attr)}}">
          <span id="ldapsetting-usernameattr"></span><br>
          <input type="hidden" name="username_case_insensitive" value="0">
          <input type="checkbox" name="username_case_insensitive" value="1" @if($ldap->username_case_insensitive == "1" || old('username_case_insensitive') == "1") checked='checked' @endif>  : 大文字と小文字を区別しない
        </td>
        <th align="left" class="gray">メールアドレス属性</th>
        <td><input type="text" name="mail_attr" size="20" value="{{old('mail_attr', $ldap->mail_attr)}}"></td>
      </tr>
        <th align="left" class="gray">社員番号属性</th>
        <td><input type="text" name="employee_id_attr" size="20" value="{{old('employee_id_attr', $ldap->employee_id_attr)}}"></td>
        <th align="left" class="gray">氏名属性</th>
        <td><input type="text" name="jpname_attr" size="20" value="{{old('jpname_attr', $ldap->jpname_attr)}}"></td>
      </tr>
      <tr>
        <th align="left" class="gray">部署属性</th>
        <td><input type="text" name="department_attr" size="20" value="{{old('department_attr', $ldap->department_attr)}}"></td>
        <th align="left" class="gray">役職属性</th>
        <td><input type="text" name="post_attr" size="20" value="{{old('post_attr', $ldap->post_attr)}}"></td>
      </tr>
      <tr>
        <th align="left" class="gray">任意データ1属性</th>
        <td><input type="text" name="custom_data1_attr" size="20" value="{{old('custom_data1_attr', $ldap->custom_data1_attr)}}"></td>
        <th align="left" class="gray">任意データ2属性</th>
        <td><input type="text" name="custom_data2_attr" size="20" value="{{old('custom_data2_attr', $ldap->custom_data2_attr)}}"></td>
      </tr>
      <tr>
        <th align="left" class="gray">任意データ3属性</th>
        <td><input type="text" name="custom_data3_attr" size="20" value="{{old('custom_data3_attr', $ldap->custom_data3_attr)}}"></td>
        <th align="left" class="gray">備考属性</th>
        <td><input type="text" name="comment_attr" size="20" value="{{old('comment_attr', $ldap->comment_attr)}}"></td>
      </tr>
      <tr>
        <th align="left" class="gray">承認権限属性</th>
        <td>
          <input type="text" name="privilege_attr" size="20" value="{{old('privilege_attr', $ldap->privilege_attr)}}">
          <span id="ldapsetting-privilegeattr"></span>
        </td>
        <th align="left" class="gray">承認グループ属性</th>
        <td><input type="text" name="flow_group_attr" size="20" value="{{old('flow_group_attr', $ldap->flow_group_attr)}}"></td>
      </tr>
      <tr>
        <th class="gray"></th>
        <td colspan="3"><input type="submit" name="submit" value="送信"></td>
      </tr>
    </table>
  </div>
  {{Form::close()}}
@endsection

@section('script')
<script src="{!! asset('js/tooltips.js') !!}"></script>
<script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
<script src="{!! asset('js/scvmanager/ldapsetting.js') !!}"></script>
@endsection
