<!-- scv/resources/views/scvusers/ldaps/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
<h3>LDAP管理</h3>
</div>

<div style="clear:both"></div>

<button onclick="location.href='{{URL::to('/scvmanager/scvusers/ldaps/create')}}'" @if (!$can_create) disabled @endif>作成</button>
<button onclick="location.href='{{URL::to('/scvmanager/scvusers')}}'">戻る</button>
<div class="table-responsive">
<table class="table table-condensed table-striped table-bordered">
  <thead>
    <tr>
      <th align="left">ID</th>
      <th align="left">設定名</th>
      <th align="left">ホスト</th>
      <th align="left">ポート</th>
      <th align="left">組織</th>
      <th align="left">ベースDN</th>
      <th align="left">フィルター</th>
      <th align="left">ユーザ名属性</th>
      <th align="left">メールアドレス属性</th>
      <th align="left">最終同期日時</th>
    </tr>
  </thead>
  <tbody>
  @foreach($ldaps as $ldap)
    <tr>
      <td>{{$ldap->id}}</td>
      <td><a href="{{URL::to('/scvmanager/scvusers/ldaps/' . $ldap->id)}}">{{$ldap->name}}</a></td>
      <td>{{$ldap->host}}</td>
      <td>{{$ldap->port}}</td>
      <td>{{$ldap->organization->name}}</td>
      <td>{{$ldap->dn}}</td>
      <td>{{$ldap->filter}}</td>
      <td>{{$ldap->username_attr}}</td>
      <td>{{$ldap->mail_attr}}</td>
      <td>{{$ldap->synced_at}}</td>
    </tr>
  @endforeach
  </tbody>
</table>
</div>

@endsection

