@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/ldaps.css') !!}">
@endsection

@section('content')

<div class="page-header">
  <h3>LDAP管理</h3>
</div>
@if(Session::has('err'))
  <p style="color:red;">{{session('err')}}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button onclick="location.href='/scvmanager/scvusers/ldaps/{{$ldapid}}'">戻る</button>
<h4>追加するユーザ ({{ number_format(count($adduser)) }}件)</h4>
@if(empty($adduser))
<p class="text-info">追加するユーザはありません。</p>
@else
<div class="table-responsive" style="max-height:200px;overflow-y: scroll">
  <table class="table table-condensed table-striped table-bordered scv-ldapsearch">
    <thead>
      <tr>
        <th>ユーザ名</th>
        <th>メールアドレス</th>
        <th>社員番号</th>
        <th>氏名</th>
        <th>部署</th>
        <th>役職</th>
        <th>任意データ1</th>
        <th>任意データ2</th>
        <th>任意データ3</th>
        <th>承認権限</th>
        <th>承認グループ</th>
        <th>備考</th>
      </tr>
    </thead>
    <tbody>
    @foreach($adduser as $au)
      <tr>
        <td>{{$au->name}}</td>
        <td>{{$au->mail}}</td>
        <td>{{$au->employee_id}}</td>
        <td>{{$au->jpname}}</td>
        <td>{{$au->department}}</td>
        <td>{{$au->post}}</td>
        <td>{{$au->custom_data1}}</td>
        <td>{{$au->custom_data2}}</td>
        <td>{{$au->custom_data3}}</td>
        <td>{{($au->privilege) ? 'あり' : 'なし'}}</td>
        <td>{{$au->flow_group}}</td>
        <td>{{$au->comment}}</td>
      </tr>
    @endforeach
    </tbody>
  </table>
</div>
@endif
<h4>削除するユーザ ({{ number_format(count($deluser)) }}件)</h4>
@if(empty($deluser))
<p class="text-info">削除するユーザはありません。</p>
@else
<div class="table-responsive" style="max-height:200px;overflow-y: scroll">
  <table class="table table-condensed table-striped table-bordered scv-ldapsearch">
    <thead>
      <tr>
        <th>ユーザ名</th>
        <th>メールアドレス</th>
        <th>社員番号</th>
        <th>氏名</th>
        <th>部署</th>
        <th>役職</th>
        <th>任意データ1</th>
        <th>任意データ2</th>
        <th>任意データ3</th>
        <th>承認権限</th>
        <th>承認グループ</th>
        <th>備考</th>
      </tr>
    </thead>
    @foreach($deluser as $du)
      <tr>
        <td>{{$du->name}}</td>
        <td>{{$du->email}}</td>
        <td>{{$du->employee_id}}</td>
        <td>{{$du->jpname}}</td>
        <td>{{$du->department}}</td>
        <td>{{$du->post}}</td>
        <td>{{$du->custom_data1}}</td>
        <td>{{$du->custom_data2}}</td>
        <td>{{$du->custom_data3}}</td>
        <td>{{($du->privilege) ? 'あり' : 'なし'}}</td>
        <td>{{$du->flow_group}}</td>
        <td>{{$du->comment}}</td>
      </tr>
    @endforeach
  </table>
</div>
@endif
@if(!empty($adduser) || !empty($deluser))
<br>
{{Form::open(['url' => '/scvmanager/scvusers/ldapsearch/' . $ldapid, 'method' => 'post'])}}
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="submit" name="submit" value="実行">
{{Form::close()}}
@endif
@endsection

