<!-- scv/resources/views/scvusers/ldaps/show.blade.php -->
@extends('layout.default')
@section('content')

<?php
 $case_insensitive_msg = $ldap->username_case_insensitive == "1" ? "大文字と小文字を区別しない" : "大文字と小文字を区別する"; ?>

<div class="page-header">
  <h3>LDAP設定詳細</h3>
</div>
@if(Session::has('err'))
  <p style="color:red;">{{session('err')}}</p>
@endif
@if(Session::has('success'))
  <p class="text-info">{{session('success')}}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

{{Form::open(['url' => '/scvmanager/scvusers/ldaps/' . $ldap->id, 'method' => 'delete'])}}
<button type="button" onclick="location.href='/scvmanager/scvusers/ldaps'">戻る</button>
<button type="button" onclick="location.href='{{URL::to('/scvmanager/scvusers/ldapsearch/' . $ldap->id)}}'">LDAP検索</button>
<button type="button" onclick="location.href='{{URL::to('/scvmanager/scvusers/ldaps/' . $ldap->id . '/edit')}}'">設定変更</button>
{{Form::submit('削除')}}
{{Form::close()}}
<div class="table-responsive">
  <table class="table table-condensed table-bordered">
    <tr>
      <th align="left" class="gray">設定名</th>
      <td colspan="3">{{$ldap->name}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">ホスト</th>
      <td>{{$ldap->host}}</td>
      <th align="left" class="gray">ポート</th>
      <td>{{$ldap->port}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">アカウント</th>
      <td colspan="3">{{$ldap->user}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">ベースDN</th>
      <td>{{$ldap->dn}}</td>
      <th align="left" class="gray">組織</th>
      <td>{{$ldap->organization->name}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">フィルター</th>
      <td>{{$ldap->filter}}</td>
      <th align="left" class="gray">登録時所属グループ</th>
      <td>{{$ldap->group->name}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">ユーザ名属性</th>
      <td>{{$ldap->username_attr}} <br>{{$case_insensitive_msg}}</td>
      <th align="left" class="gray">メールアドレス属性</th>
      <td>{{$ldap->mail_attr}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">社員番号属性</th>
      <td>{{$ldap->employee_id_attr}}</td>
      <th align="left" class="gray">氏名属性</th>
      <td>{{$ldap->jpname_attr}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">部署属性</th>
      <td>{{$ldap->department_attr}}</td>
      <th align="left" class="gray">役職属性</th>
      <td>{{$ldap->post_attr}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">任意データ1属性</th>
      <td>{{$ldap->custom_data1_attr}}</td>
      <th align="left" class="gray">任意データ2属性</th>
      <td>{{$ldap->custom_data2_attr}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">任意データ3属性</th>
      <td>{{$ldap->custom_data3_attr}}</td>
      <th align="left" class="gray">備考属性</th>
      <td>{{$ldap->comment_attr}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">承認権限属性</th>
      <td>{{$ldap->privilege_attr}}</td>
      <th align="left" class="gray">承認グループ属性</th>
      <td>{{$ldap->flow_group_attr}}</td>
    </tr>
    <tr>
      <th align="left" class="gray">最終同期日時</th>
      <td colspan="3">{{$ldap->synced_at}}</td>
    </tr>
  </table>
</div>
@endsection

@section('script')
<script type="text/javascript">
$(function() {
  $("form").submit(function(){
    if(confirm("{{$ldap->name}}を削除しますか？")){
      return true;
    }else{
      return false;
    }
  });
});
</script>
@endsection
