<!-- scv/resources/views/scvusers/show.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>ユーザ詳細</h3>
</div>
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
@if(Session::has('success'))
  <p class="text-success">{{ Session::get('success') }}</p>
@endif
<?php
 $org_group = $scvuser->org_group; $id = $scvuser->id; $name = $scvuser->name; $employee_id = $scvuser->employee_id; $jpname = $scvuser->jpname; $groupid = $scvuser->groupid; $groupname = $scvuser->groupname; $email = $scvuser->email; $comment = $scvuser->comment; $department = $scvuser->department; $post = $scvuser->post; $custom_data1 = $scvuser->custom_data1; $custom_data2 = $scvuser->custom_data2; $custom_data3 = $scvuser->custom_data3; $flow_group = $scvuser->flow_group; $privilege = $scvuser->privilege; $created_at = $scvuser->created_at; $updated_at = $scvuser->updated_at; $updurl ="/scvmanager/scvusers/".$id."/edit"; $url = "/scvmanager/scvusers/$id"; $passwordurl = "/scvmanager/edit_user_passwd/$id/edit"; if (isset($errmsg)){ echo '<p><span style="color:red">'.$errmsg.'</font></p>'; }else{ echo '<p>&nbsp;</p>'; } ?>
<form action="{{$url}}" method="POST" id="delete">
<input type="hidden" name="_token" value="{{csrf_token()}}">
<input type="hidden" name="org_group" value="{{ $org_group }}">
<input type="hidden" name="name" value="{{$name}}">
<input type="hidden" name="_method" value="delete">
<button type="button" onclick="location.href='/scvmanager/scvusers'">戻る</button>
@if ($name !== 'scvtemplate')
  <button type="button" onclick="location.href='{{$updurl}}'">{{$name}}を編集</button>
@endif
@if (App\Libs\ConfHelper::usingPassword() || $name == 'scvtemplate')
  <button type="button" onclick="location.href='{{$passwordurl}}'">パスワード変更</button>
@endif
@if ($name != "scvtemplate")
  <input type="submit" name="remove" onclick="return check();" value="削除">
@endif
<div class="table-responsive">
  <table class="table table-condensed table-bordered two-stages-layout">
    <tbody>
      <tr>
        <th width="150">ID</th>
        <td>{{ $id }}</td>
        <th width="150">グループID</th>
        <td>{{ $groupid }}</td>
      </tr>
      <tr>
        <th>ユーザ</th>
        <td id="name">{{ $name }}</td>
        <th>グループ名</th>
        <td><a href="../scvgroups/{{$groupid}}" >{{$groupname}}</a></td>
      </tr>
      <tr>
        <th>氏名</th>
        <td id="name">{{ $jpname }}</td>
        <th>社員番号</th>
        <td>{{ $employee_id }}</td>
      </tr>
      <tr>
        <th>部署</th>
        <td>{{ $department }}</td>
        <th>役職</th>
        <td>{{ $post }}</td>
      </tr>
      <tr>
        <th>任意データ1</th>
        <td>{{ $custom_data1 }}</td>
        <th>任意データ2</th>
        <td>{{ $custom_data2 }}</td>
      </tr>
      <tr>
        <th>任意データ3</th>
        <td>{{ $custom_data3 }}</td>
        @if ($flow_available)
          <th>SCVFlowの承認権限</th>
          <td>
          @if ($privilege)
            あり
          @else
            なし
          @endif
          </td>
        @else
          <th></th>
          <td></td>
        @endif
      </tr>
      @if ($flow_available)
        <tr>
          <th></th>
          <td></td>
          <th>SCVFlowの承認グループ</th>
          <td>{{ $flow_group }}</td>
        </tr>
      @endif
      <tr>
        <th>Eメール</th>
        <td>{{ $email }}</td>
        <th>備考</th>
        <td>{{ $comment }}</td>
      </tr>
      <tr>
        <th>登録日</th>
        <td>{{ $created_at }}</td>
        <th>更新日</th>
        <td>{{ $updated_at }}</td>
      </tr>
    </tbody>
  </table>
</div>
</form>
@stop
@section('script')
<script type="text/javascript">
  function check(){
      if(confirm("{{$name}}を削除しますか？")){
        return true;
      }else{
        return false;
      }
  }
</script>
@stop
