<!-- scv/resources/views/scvx_chrome_settings/edit.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/chrome_settings.css') !!}">
@endsection

@section('content')
  <div class="page-header">
    <h3>SCVX Chrome設定変更<span class="scvx-icon"></span></h3>
  </div>

  @if(Session::has('flash_msg'))
    <p style="color:red">{!! Session::get('flash_msg')!!}</p>
  @endif
  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/scvx_chrome_settings') }}'">戻る</button>

  {{ Form::model($setting, ['url' => url("/scvmanager/scvx_chrome_settings/$setting->id"), 'method' => 'put']) }}
  {{ Form::hidden('id', $setting->id) }}
  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名 <span style="color: red">*</span></th>
      <td>CHROME_{{ Form::text('name', preg_replace('/^CHROME_/', '', $setting->name), ['required' => 'required']) }}</td>
    </tr>
    <tr>
      <th class="gray">組織名 <span style="color: red">*</span></th>
      <td>
      @if (\Auth::user()->organization_id === 1)
      <select name="organization_id">
          @foreach ($organizations as $org)
            @if ($setting->organization_id === $org->id)
              <option selected value={{$org->id}}>{{$org->name}}</option>
            @else
              <option value={{$org->id}}>{{$org->name}}</option>
            @endif
          @endforeach
      </select>
      @else
          <input type="hidden" name="organization_id" value={{$organizations->id}}>
          {{$organizations->name}}
      @endif
      </td>
    </tr>
    <tr>
      <th class="gray">ホームページ</th>
      <td>{{ Form::text('homepage') }}</td>
    </tr>
    <tr>
      <th class="gray">スタートページ</th>
      <td>{{ Form::text('startup_page') }}</td>
    </tr>
    <tr>
      <th class="gray">ダウンロードフォルダ名</th>
      <td>{{ Form::text('downloaddir') }}</td>
    </tr>
    <tr>
      <th class="gray">プロファイル保存</th>
      {{ Form::hidden('save_profile', 0) }}
      <td>{{ Form::checkbox('save_profile', 1, null, ['id' => 'save_profile']) }}</td>
    </tr>
    <tr>
      <th class="gray">履歴保存</th>
      {{ Form::hidden('save_history', 0) }}
      <td>{{ Form::checkbox('save_history', 1, null, ['class' => 'save_checkbox']) }}</td>
    </tr>
    <tr>
      <th class="gray">パスワード保存</th>
      {{ Form::hidden('save_password', 0) }}
      <td>{{ Form::checkbox('save_password', 1, null, ['class' => 'save_checkbox']) }}</td>
    </tr>
    <tr>
      <th class="gray">Cookie保存</th>
      {{ Form::hidden('save_cookie', 0) }}
      <td>{{ Form::checkbox('save_cookie', 1, null, ['class' => 'save_checkbox']) }}</td>
    </tr>
    <tr>
      <th class="gray">ブックマーク保存</th>
      {{ Form::hidden('save_bookmark', 0) }}
      <td>{{ Form::checkbox('save_bookmark', 1, null, ['class' => 'save_checkbox']) }}</td>
    </tr>
    <tr>
      <th class="gray">設定ページ非表示</th>
      {{ Form::hidden('hide_internal_pages', 0) }}
      <td>{{ Form::checkbox('hide_internal_pages') }}</td>
    </tr>
    <tr>
      <th class="proxy_header gray">プロキシ</th>
      <td>
        <select name="proxy_type">
          <option name="proxy0" value="0" @if($setting->proxy_type=="0") selected @endif>プロキシを使用しない</option>
          <option name="proxy1" value="1" @if($setting->proxy_type=="1") selected @endif>手動でプロキシを設定する</option>
          <option name="proxy2" value="2" @if($setting->proxy_type=="2") selected @endif>自動プロキシ設定スクリプト URL</option>
        </select>
      </td>
    </tr>
    <tr class="manual">
      <td>HTTPプロキシホスト : {{ Form::text('http_proxy_host') }}</td>
    </tr>
    <tr class="manual">
      <td>HTTPプロキシポート : {{ Form::number('http_proxy_port', null, ['min' => 0, 'step' => 1]) }}</td>
    </tr>
    <tr class="manual">
      {{ Form::hidden('same_proxy', 0) }}
      <td><label>HTTP,SSLでこのプロキシを使用する</label>{{ Form::checkbox('same_proxy', 1, null) }}</td>
    </tr>
    <tr class="manual">
      <td>SSLプロキシホスト : {{ Form::text('ssl_proxy_host') }}</td>
    </tr>
    <tr class="manual">
      <td>SSLプロキシポート : {{ Form::number('ssl_proxy_port', null, ['min' => 0, 'step' => 1]) }}</td>
    </tr>
    <tr class="manual no_proxy">
      <td>
        プロキシ無しで接続 : {{ Form::text('no_proxy_host', $setting->no_proxy_host) }}
        <span class="glyphicon glyphicon-question-sign text-info" id="no_proxy_pop" data-toggle="popover" title="プロキシ無しで接続"></span>
      </td>
    </tr>
    <tr class="proxy_url">
      <td>URL : {{ Form::text('proxy_url') }}</td>
    </tr>
    <tr>
      <th class="gray">最大タブ数</th>
      <td>{{ Form::number('max_tab', null, ['min' => '0', 'step' => '1', 'max' => '255']) }}</td>
    </tr>
    <tr>
      <th class="gray">X-Forwarded-For有効化</th>
      {{ Form::hidden('xff_flag', 0) }}
      <td>{{ Form::checkbox('xff_flag', 1, null) }}</td>
    </tr>
    <tr>
      <th class="gray">Proxy-Authorization有効化</th>
      {{ Form::hidden('enable_pauth', 0) }}
      <td>
        {{ Form::checkbox('enable_pauth') }}
        <span class="glyphicon glyphicon-question-sign text-info" id="pauth_pop" data-toggle="popover" title="Proxy-Authorization"></span>
        <br><label>ユーザ名、パスワードを指定する：{{Form::checkbox('pauth_account', null, null, ['id' => 'pauth_account'])}}</label>
        <span class="glyphicon glyphicon-question-sign text-info" id="pauth_account_pop" data-toggle="popover" title="ユーザ名、パスワードを指定する"></span>
        <div id="pauth_account_inputs">
          ユーザ名　：{{Form::text('pauth_user', null, ['maxlength' => 255])}}
          <br>
          パスワード：{{Form::text('pauth_pass', null, ['id' => 'pauth_pass', 'maxlength' => 96])}} <button id="show_password">表示</button>
        </div>
      </td>
    </tr>
    <tr>
      <th class="gray">Bookmarkトップフォルダ名</th>
      <td>{{ Form::text('bookmark_toplevel', null, [ 'placeholder' => '管理対象のブックマーク']) }}</td>
    </tr>
  </table>
  <div>
    <h5>
      Bookmark設定
      <span class="glyphicon glyphicon-question-sign text-info" id="bookmark_setting_pop" data-toggle="popover" title="Bookmark設定<span class='revobr-icon'></span>"></span>
      <a data-toggle="modal" data-target="#bookmark-modal" data-backdrop="static" data-clickbutton="new">
        <span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
      </a>
    </h5>
    <table id="bookmarks-table" class="table table-condensed table-bordered" data-hideplace="true">
      <input type="hidden" name="bookmarks">
      <tr>
        <th>No.</th>
        <th>ブックマーク名</th>
        <th>URL</th>
        <th>フォルダ名</th>
        <th></th>
        <th></th>
      </tr>
    </table>
  </div>
  {{ Form::submit('変更') }}
  {{ Form::close() }}
  @include('managed_bookmarks.modal', ['hideplace' => true])
@stop

@section('script')
<script>
  var bookmarks = JSON.parse(@json(old('bookmarks', $setting->bookmarks) ?? null));
  bookmarks = bookmarks ? bookmarks : [];
</script>
<script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
<script type="text/javascript" src="{!! asset('js/tooltips.js') !!}"></script>
<script type="text/javascript" src="{!! asset('js/scvmanager/scvx_chrome.js') !!}"></script>
<script type="text/javascript" src="{!! asset('js/scvmanager/bookmark.js') !!}"></script>
@stop
