<!-- scv/resources/views/scvx_chrome_settings/index.blade.php -->
@extends('layout.default')
@section('content')

  <div class="page-header">
    <h3>SCVX Chrome設定<span class="scvx-icon"></span></h3>
  </div>

  <p>SCVXで使用するGoogleChromeの設定を管理します。</p>
  @if(Session::has('flash_msg'))
    <p style="color:red">{!! Session::get('flash_msg')!!}</p>
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/scvgroups') }}'">戻る</button>
  <button onclick="location.href='{{ URL::to('/scvmanager/scvx_chrome_settings/create') }}'">作成</button>
  <div class="table-responsive">
    <table class="table table-condensed table-bordered table-striped">
      <tr>
        <th>設定名</th>
        <th>組織名</th>
        <th>ホームページ</th>
      </tr>
      @foreach ($settings as $s)
        <tr>
          <td><a href="{{ URL::to("/scvmanager/scvx_chrome_settings/$s->id") }}">{{ $s->name }}</a></td>
          <td>{{ $s->organization_name }}</td>
          <td>{{ $s->homepage }}</td>
        </tr>
      @endforeach
    </table>
  </div>
@stop

@section('script')
  <script>
  </script>
@stop
