<!-- scv/resources/views/scvx_chrome_settings/show.blade.php -->
@extends('layout.default')
@section('content')

  <div class="page-header">
    <h3>SCVX Chrome設定詳細<span class="scvx-icon"></span></h3>
  </div>

  @if(Session::has('flash_msg'))
      <p style="color:red">{!! Session::get('flash_msg')!!}</p>
    @endif
  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  <?php
 $bookmarks = $setting->bookmarks ? json_decode($setting->bookmarks) : []; switch ($setting->proxy_type) { case '0': $proxy_type = "使用しない"; break; case '1': $proxy_type = "手動"; break; case '2': $proxy_type = "スクリプト"; break; } ?>

  {{ Form::open(['url' => "/scvmanager/scvx_chrome_settings/{$setting->id}", 'method' => 'delete']) }}
  <button type="button" onclick="location.href='{{ URL::to('/scvmanager/scvx_chrome_settings') }}'">戻る</button>
  <button type="button" onclick="location.href='/scvmanager/scvx_chrome_settings/{{ $setting->id }}/edit'">編集</button>
  <button type="button" onclick="location.href='/scvmanager/scvx_chrome_settings/cert/show/{{ $setting->id }}'">証明書管理</button>
  {{ Form::hidden('id', $setting->id) }}
  {{ Form::submit('削除', ['onclick' => 'return check();']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名</th>
      <td>{{ $setting->name }}</td>
    </tr>
    <tr>
      <th class="gray">組織名</th>
      <td>{{ $setting->organization_name }}</td>
    </tr>
    <tr>
      <th class="gray">ホームページ</th>
      <td>{{ $setting->homepage}}</td>
    </tr>
    <tr>
      <th class="gray">スタートページ</th>
      <td>{{ $setting->startup_page}}</td>
    </tr>
    <tr>
      <th class="gray">ダウンロードフォルダ名</th>
      <td>{{ $setting->downloaddir}}</td>
    </tr>
    <tr>
      <th class="gray">プロファイル保存</th>
      <td>{{ $setting->save_profile ? '保存する' : '保存しない' }}</td>
    </tr>
    <tr>
      <th class="gray">履歴保存</th>
      <td>{{ $setting->save_history ? '保存する' : '保存しない' }}</td>
    </tr>
    <tr>
      <th class="gray">パスワード保存</th>
      <td>{{ $setting->save_password ? '保存する' : '保存しない' }}</td>
    </tr>
    <tr>
      <th class="gray">Cookie保存</th>
      <td>{{ $setting->save_cookie ? '保存する' : '保存しない' }}</td>
    </tr>
    <tr>
      <th class="gray">ブックマーク保存</th>
      <td>{{ $setting->save_bookmark ? '保存する' : '保存しない'}}</td>
    </tr>
    <tr>
      <th class="gray">設定ページ</th>
      <td>{{ $setting->hide_internal_pages ? '表示しない' : '表示する' }}</td>
    </tr>
    <tr>
      <th class="gray">プロキシタイプ</th>
      <td>{{ $proxy_type }}</td>
    </tr>
    @if($setting->proxy_type==1)
    <tr>
      <th class="gray">HTTPプロキシホスト</th>
      <td>{{ $setting->http_proxy_host }}</td>
    </tr>
    <tr>
      <th class="gray">HTTPプロキシポート</th>
      <td>{{ $setting->http_proxy_port }}</td>
    </tr>
    <tr>
      <th class="gray">SSLプロキシホスト</th>
      <td>{{ $setting->ssl_proxy_host }}</td>
    </tr>
    <tr>
      <th class="gray">SSLプロキシポート</th>
      <td>{{ $setting->ssl_proxy_port }}</td>
    </tr>
    <tr>
      <th class="gray">プロキシ無しで接続</th>
      <td>{{ $setting->no_proxy_host }}</td>
    </tr>
    @endif
    @if($setting->proxy_type==2)
    <tr>
      <th class="gray">プロキシスクリプト</th>
      <td>{{ $setting->proxy_url }}</td>
    </tr>
    @endif
    <tr>
      <th class="gray">最大タブ数</th>
      <td>{{ $setting->max_tab}}</td>
    <tr>
      <th class="gray">X-Forwarded-For有効化</th>
      <td>{{ $setting->xff_flag ? '有効' : '無効' }}</td>
    </tr>
    <tr>
      <th class="gray">Proxy-Authorization有効化</th>
      <td>{{ $setting->enable_pauth ? '有効' : '無効'}}</td>
    </tr>
    <tr>
      <th class="gray">Bookmarkトップフォルダ名</th>
      <td>{{ $setting->bookmark_toplevel }}</td>
    </tr>
  </table>

  @if($bookmarks)
    <br>
    <table class="table table-condensed table-bordered">
      <tbody>
        <tr>
          <th colspan="4" class="gray">ブックマーク</th>
        </tr>
        <tr>
          <th>ブックマーク名</th>
          <th>URL</th>
          <th>フォルダ名</th>
        </tr>
        @foreach($bookmarks as $b)
        <tr>
          <td>{{$b->Title}}</td>
          <td>{{$b->URL}}</td>
          <td>{{$b->Folder}}</td>
        </tr>
        @endforeach
      </tbody>
    </table>
  @endif
@stop

@section('script')
<script>
  $(function() {
    $("form").submit(function() {
      if (confirm("{{ $setting->name }}を削除しますか？")) {
        return true;
      } else {
        return false;
      }
    });
  });

</script>
@stop
