<!-- scv/resources/views/serverlist/index.blade.php -->
@extends('layout.default')
@section('head')
<script src="{!! asset('js/codemirror/codemirror.js') !!}"></script>
<script src="{!! asset('js/codemirror/yaml.js') !!}"></script>
<link rel="stylesheet" href="{!! asset('css/codemirror/codemirror.css') !!}">
<link rel="stylesheet" href="{!! asset('css/scvmanager/serverlist.css') !!}">
@endsection
@section('content')

<div class="page-header">
  <h3>URLリダイレクト管理<span class="scvx-icon"></span><span class="revobr-icon"></span></h3>
</div>

<button type="button" onclick="location.href='{{URL::to('/scvmanager/scvconf')}}'">戻る</button>

@if (Session::has('status'))
  <p class="text-primary">{{ session('status') }}</p>
@else
  <p class="text-primary">
    指定したURLは正規表現、前方一致の順に評価されます。<br>
    URLの登録件数は前方一致、正規表現合わせて1,000件以内を推奨しております。（最大1,000,000Byte程度）<br>
    #から始まる行はコメントとして登録可能です。
  </p>
@endif
@if ($errors->has('oversized'))
  <p class="error_message">
    登録可能サイズを超えました。<br>
    リストの登録数を減らしてください。
  </p>
@endif
@if ($errors->has('limit_over'))
  <p class="error_message">
    登録可能件数を超えました。<br>
    前方一致、正規表現合わせて500件まで登録可能です。
  </p>
@endif

{{ Form::model($server_lists, ['url' => '/scvmanager/serverlist'])}}
  <h4 style="display:inline;">前方一致</h4>
  <button class="cm_button" type="button" data-toggle="modal" data-target="#sampleModal" data-areatype="forward_match">拡大表示</button>
  <textarea id="forward_area" style="width:100%;height:300px;" name="forward">{{$server_lists->forward_match_list}}</textarea>
  <br>
  <h4 style="display:inline;">正規表現</h4>
  <button class="cm_button" type="button" data-toggle="modal" data-target="#sampleModal" data-areatype="regexp">拡大表示</button>
  <textarea id="regexp_area" style="width:100%;height:300px;" name="regexp">{{$server_lists->regexp_list}}</textarea>
  <br>
  <label>一致したらリダイレクトする：{{ Form::checkbox('reverse') }}</label>
  <br><br>
  <input type="submit" value="登録">
{{Form::close()}}

<hr>

<div id="regexp_test">
  <div class="page-header">
    <h3>正規表現チェック</h3>
  </div>
  <table class="table table-bordered">
    <tr>
      <th class="active">正規表現</th>
      <td><input type="text" id="regexp" style="width:100%"></td>
    </tr>
    <tr>
      <th class="active">文字列</th>
      <td><input type="text" id="string" style="width:100%"></td>
    </tr>
    <tr>
      <td><button id="regexp_btn">チェック</button></td>
      <td><div id="result"></div></td>
    </tr>
  </table>
</div>

{{-- サンプルのHTML読み込み --}}
@include('serverlist/sample')

{{-- モーダル・ダイアログ --}}
<div class="modal fade" id="sampleModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal"><span>×</span></button>
          <h4 class="modal-title" id="title"></h4>
        </div>
        <div class="modal-body">
          <textarea id="modal_editor" style="width:100%;height:100%;resize:none;"></textarea>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">閉じる</button>
        </div>
      </div>
    </div>
  </div>
{{-- モーダル・ダイアログ --}}

@endsection
@section('script')
<script type="text/javascript" src="{!! asset('js/scvmanager/whitelist.js') !!}"></script>
@endsection

