<div id="sample">
  <div class="page-header">
    <h3>サンプル</h3>
  </div>
  <h4>記号</h4>
  <table class="table table-striped table-condensed table-hover table-bordered">
    <tr>
      <th>記号</th>
      <th>説明</th>
      <th>使用例</th>
      <th>例の説明</th>
    </tr>
    <tr>
      <td>.</td>
      <td>任意の1文字</td>
      <td>.+</td>
      <td>任意の文字列</td>
    </tr>
    <tr>
      <td>*</td>
      <td>直前の文字の0回以上の繰り返し</td>
      <td>hoge*</td>
      <td>hogもしくはhogeee...とマッチ</td>
    </tr>
    <tr>
      <td>+</td>
      <td>直前の文字の1回以上の繰り返し</td>
      <td>hoge+</td>
      <td>hogeもしくはhogeee...とマッチ</td>
    </tr>
    <tr>
      <td>?</td>
      <td>直前の文字が0個または1個の場合</td>
      <td>hoge?</td>
      <td>hogもしくはhogeとマッチ</td>
    </tr>
    <tr>
      <td>^</td>
      <td>行の先頭</td>
      <td>^http</td>
      <td>行頭がhttp</td>
    </tr>
    <tr>
      <td>$</td>
      <td>行の末尾</td>
      <td>scvx$</td>
      <td>行末がscvx</td>
    </tr>
    <tr>
      <td>[]</td>
      <td>カッコ内の1文字とマッチ</td>
      <td>[a-z]</td>
      <td>小文字のa~zにマッチ</td>
    </tr>
    <tr>
      <td>[^]</td>
      <td>カッコ内の1文字以外にマッチ</td>
      <td>[^A-Z]</td>
      <td>大文字のA~Z以外にマッチ</td>
    </tr>
    <tr>
      <td>{n}</td>
      <td>n回の繰り返し</td>
      <td>ht{2}p</td>
      <td>httpにマッチするがhtttpにはマッチしない</td>
    </tr>
    <tr>
      <td>{n,}</td>
      <td>n回以上の繰り返し</td>
      <td>a{2,}</td>
      <td>aにはマッチしないが、aa... にマッチ</td>
    </tr>
    <tr>
      <td>{n,m}</td>
      <td>n~m回の繰り返し</td>
      <td>a{2,4}</td>
      <td>aa, aaa, aaaaにマッチ</td>
    </tr>
    <tr>
      <td>|</td>
      <td>前後のどちらかにマッチ</td>
      <td>hoge|fuga</td>
      <td>hogeまたはfugaにマッチ</td>
    </tr>
    <tr>
      <td>\</td>
      <td>直後の文字をエスケープ</td>
      <td>\.</td>
      <td>.を任意の1文字ではなく文字の.として扱う</td>
    </tr>
  </table>
  <h4>URL</h4>
  <table class="table table-striped table-condensed table-hover table-bordered">
    <tr>
      <th>パターン</th>
      <th>マッチする例</th>
      <th>マッチしない例</th>
    </tr>
    <tr>
      <td>.*jscom.jp.*</td>
      <td>
        <ul>
          <li>http://jscom.jp</li>
          <li>https://jscom.jp/scvx</li>
          <li>ftp://jscom.jp</li>
        </ul>
      <td>
        <ul>
          <li>https://google.co.jp</li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>
        https://jscom.jp/(?!scvx)<br>
        https://jscom.jp/以降がscvx以外の文字列
      </td>
      <td>
        <ul>
          <li>https://jscom.jp/juniper</li>
          <li>https://jscom.jp/ruckuswireless</li>
        </ul>
      </td>
      <td>
        <ul>
          <li>https://jscom.jp/scvx</li>
        </ul>
      </td>
    </tr>

  </table>

  <h4>IPアドレス</h4>
  <table class="table table-striped table-condensed table-hover table-bordered">
    <th>CIDR表記</th>
    <th>パターン</th>
    <tr>
      <td>10.0.0.0/8</td>
      <td>
        http://10\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-4])
      </td>
    </tr>
    <tr>
      <td>172.16.0.0/12</td>
      <td>
        http://172\.(1[6-9]|2[0-9]|3[0-1])\.([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-4])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])
      </td>
    </tr>
    <tr>
      <td>192.168.0.0/16</td>
      <td>
        http://192\.168\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-4])
      </td>
    </tr>
  </table>
</div>
