<!-- scv/resources/views/share/create.blade.php -->
@extends('layout.default')
@section('content')
<style>
th {
  width: 500px;
}
</style>

<div class="page-header">
  <h3>共有フォルダ設定</h3>
</div>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button onclick="location.href='{{URL::to('/scvmanager/share')}}'">戻る</button>
<form action="{{URL::to('/scvmanager/share')}}" method="post">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <div class="table-responsive">
    <table class="table table-condensed table-bordered">
      <tr>
        <th>
          共有フォルダ設定名
          <span style="color:red">*</span>
        </th>
        <td>
          SHARE_<input type="text" name="shname" value="{{Input::old('shname')}}">
        </td>
      </tr>
    </table>
    <table class="table table-condensed table-bordered">
      <tr>
        <th>
          組織
          <span style="color:red">*</span>
        </th>
        <td>
          @if (\Auth::user()->organization_id === 1)
          <select name="organization_id">
            @foreach ($organizations as $org)
              <option value="{{$org->id}}"  @if(Input::old('organization_id')==$org->id) selected @endif >{{$org->name}}</option>
            @endforeach
          </select>
          @else
            <input type="hidden" name="organization_id" value={{$organizations->id}}>
            {{$organizations->name}}
          @endif
        </td>
      </tr>
    </table>
    <br>
    <table class="table table-condensed table-bordered">
      <tr>
        <th colspan="4" align="left" width="150" class="gray">共有フォルダ1</th>
      </tr>
      <tr>
        <th>
          共有フォルダ
        </th>
        <td>
          <input type="text" name="sharename1" value="{{Input::old('sharename1')}}">
          <span class="glyphicon glyphicon-question-sign text-info" id="name_pop1" data-toggle="popover" title="共有フォルダ" data-content="<small>（//server/share）の形式で入力してください。<br>SCVUSER,SCVGROUP文字列を含めるとSCVXのユーザ名、グループ名と置き換えることができます。</small>"></span>
        </td>
      </tr>
      <tr>
        <th>ドメイン（またはサーバ）</th>
        <td><input type="text" name="sharedom1" value="{{Input::old('sharedom1')}}"></td>
      </tr>
      <tr>
        <th>参照のみ</th>
        <td><input type="checkbox" name="ro1" value="ro1" @if(Input::old('ro1')=="ro1") checked  @endif></td>
      </tr>
      <tr>
        <th>ログインユーザ名、パスワードを使用しない（デフォルトは使用する）</th>
        <td><input type="checkbox" name="use_scvuser1" value="use_scvuser1" @if(Input::old('use_scvuser1')=="use_scvuser1") checked  @endif></td>
      </tr>
      <tr class="share_auth1">
        <th>ユーザ名</th>
        <td><input type="text" name="shareusr1" value="{{Input::old('shareusr1')}}"></td>
      </tr>
      <tr class="share_auth1">
        <th>パスワード</th>
        <td><input type="password" name="sharepwd1"></td>
      </tr>
    </table>
    <br>
    <table class="table table-condensed table-bordered">
      <tr>
        <th colspan="4" align="left" width="150" class="gray">共有フォルダ2</th>
      </tr>
      <tr>
        <th>
          共有フォルダ
        </th>
        <td>
          <input type="text" name="sharename2" value="{{Input::old('sharename2')}}">
          <span class="glyphicon glyphicon-question-sign text-info" id="name_pop2" data-toggle="popover" title="共有フォルダ" data-content="<small>（//server/share）の形式で入力してください。<br>SCVUSER,SCVGROUP文字列を含めるとSCVXのユーザ名、グループ名と置き換えることができます。</small>"></span>
        </td>
      </tr>
      <tr>
        <th>ドメイン（またはサーバ）</th>
        <td><input type="text" name="sharedom2" value="{{Input::old('sharedom2')}}"></td>
      </tr>
      <tr>
        <th>参照のみ</th>
        <td><input type="checkbox" name="ro2" value="ro2" @if(Input::old('ro2')=="ro2") checked  @endif></td>
      </tr>
      <tr>
        <th>ログインユーザ名、パスワードを使用しない（デフォルトは使用する）</th>
        <td><input type="checkbox" name="use_scvuser2" value="use_scvuser2" @if(Input::old('use_scvuser2')=="use_scvuser2") checked  @endif></td>
      </tr>
      <tr class="share_auth2">
        <th>ユーザ名</th>
        <td><input type="text" name="shareusr2" value="{{Input::old('shareusr2')}}"></td>
      </tr>
      <tr class="share_auth2">
        <th>パスワード</th>
        <td><input type="password" name="sharepwd2"></td>
      </tr>
    </table>
  </div>
  <input type="submit" value="登録">
@endsection
@section('script')
<script type="text/javascript" src="{!! asset('js/scvmanager/share.js') !!}"></script>
@endsection