<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- 上記の3行は一番最初に記述すること -->

  <meta name="description" content="Secure Console Vitrual">
  <meta name="author" content="tnakamura@jscom.co.jp">
  <meta name="csrf-token" content="{{csrf_token()}}">
  <script type="text/javascript" src="{!! asset('js/jquery-1.11.3.js') !!}"></script>
  <script type="text/javascript" src="{!! asset('js/Chart.min.js') !!}"></script>
  <script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
  <script type="text/javascript" src="{!! asset('js/jquery.ui.datepicker-ja.min.js') !!}"></script>
  <title>SCV</title>

  <!-- Bootstrap core CSS -->
  <link href="{!! asset('css/bootstrap.min.css') !!}" rel="stylesheet">
  <!-- Bootstrap theme -->
  <!-- link href="css/bootstrap-theme.min.css" rel="stylesheet" -->
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Latest compiled and minified CSS -->
  <!--<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">-->

  <!-- my css -->
  <link rel="stylesheet" href="{!! asset('css/scvcommon.css') !!}" type="text/css">
  <!-- カレンダー用 -->
  <link rel="stylesheet" href="{!! asset('css/jquery-ui.min.css') !!}" type="text/css" />
  <!-- common style -->
  <link rel="stylesheet" type="text/css" href="{!! asset('css/common.css') !!}">

  <style type="text/css">
    body {
      padding-top: 40px;
    }
  </style>
</head>
<body>
<nav class="navbar navbar-inverse navbar-fixed-top">
  <div class="container-fluid">
    <div class="navbar-header">
      <span class="navbar-brand" style="color:white">SCV Manager</span>
    </div>
  </div>
</nav>
<div class="container">

  <div class="page-header">
    <h3>パスワード変更</h3>
  </div>
@if (Session::has('flash_msg'))
  <p style="color:red">{{ Session::get('flash_msg')}}</p>
@endif
@if (Session::has('success'))
  <p class="text-success">{{ Session::get('success') }}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
@if (App\Libs\ADHelper::isScvxKerberos())
  <p><span style="color:red">AD連携/Kerberos認証モードです。パスワードの変更はできません。</span></p>
@elseif (App\Libs\ADHelper::isScvxSaml())
  <p><span style="color:red">SAML認証モードです。パスワードの変更はできません。</span></p>
@elseif (App\Libs\ConfHelper::usingPassword())
  <form action="{{ URL::to("/user_account/{$org}/{$user}/{$ip_int}")}}" method="post">
    <div class="table-responsive">
      <div class="form-group">
        <label for="password">Google認証</label>
        <input type="text" id="password" name="password" placeholder="6桁のパスワード" class="form-control" value="{{ Input::old('password') }}" autofocus>
      </div>
      <input type="hidden" name="_token" value="{{{ csrf_token() }}}" />
      <input type="hidden" name="ip_int" value="{{ $ip_int }}" />
      <input type="hidden" name="next" value="gauth" />
      <input type="submit" value="パスワード変更" class="btn btn-primary btn-lg btn-block">
    </div>
  </form>
@endif
  <br>
  <div><p class="pull-right"><small>{{config('scv.copyright')}}</small></p></div>
  </div>
  <br>
</body>
</html>