@extends('layout.default')
@section('content')
<div class="page-header">
  <h3>管理者アカウント作成</h3>
</div>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
@if(Session::has('success'))
  <p class="text-success">{!! Session::get('success') !!}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
<?php
 if(!isset($username)){ $username = ""; } if(!isset($email)){ $email = ""; } ?>
<button type="button" onclick="location.href='{{URL::to('/scvmanager/users')}}'">戻る</button>
<form action="{{ URL::to('/scvmanager/users')}}" method="post">
  <table class="table table-condensed table-bordered">
    <tr>
      <th width="160" class="gray">
        <label for="username">ユーザ名</label>
        <span style="color:red;">*</span>
      </th>
      <td>
        <input type="text" size="20" id="username" name="username" value="{{Input::old('username')}}">
        <span class="glyphicon glyphicon-question-sign text-info" id="name_pop" data-toggle="popover" title="ユーザ名に使用可能な文字" data-content="<small>半角英大文字、小文字、数字、アンダースコア、ピリオド、ハイフン（先頭は英数）が使用できます</small>"></span>
      </td>
      <th width="160" class="gray">組織名</th>
      <td>
        <select name="organization">
          @foreach($organizations as $organization)
            <option value="{{$organization->id}}">{{$organization->name}}</option>
          @endforeach
        </select>
      </td>
    </tr>
    <tr>
      <th class="gray">
        <label for="username">メールアドレス</label>
        <span style="color:red;">*</span>
      </th>
      <td><input type="email" seize="20"  id="email" name="email" value="{{Input::old('email')}}"></td>
      <th class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <th class="gray">
        <label for="password">パスワード</label>
        <span style="color:red;">*</span>
      </th>
      <td><input type="password"  id="password" name="password"></td>
      <th class="gray">
        <label for="password_confirmation">パスワード（確認）</label>
        <span style="color:red;">*</span>
      </th>
      <td><input type="password"  id="password_confirmation" name="password_confirmation"></td>
    </tr>
    <tr>
      <th class="gray"></th>
      <td colspan="3"><input type="submit" value="作成"></td>
    </tr>
  </table>
  <input type="hidden" name="_token" value="{{{ csrf_token() }}}" />
</form>

@endsection
@section('script')
<script type="text/javascript">
  $(function (){

    $('#name_pop').popover({trigger: 'hover',html:true});

  });
</script>
@endsection
