@extends('layout.default')
@section('content')


<div class="page-header">
	<h3>管理者アカウント変更</h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

@if (empty(Auth::user()->tmp_pwd))
  <button type="button" onclick="history.back()">戻る</button><br>
@endif

<form action="{{ URL::to('/scvmanager/users')}}/{{$user->username}}" method="POST">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="hidden" name="_method" value="PATCH">
  <input type="hidden" name="user_id" value="{{$user->id}}">
  <div class="table-responsive">
    <table class="table table-condensed table-bordered">
      <tr>
        <th align="left" width="150" class="gray">管理者名</th>
        <td>{{$user->username}}</td>
      </tr>
      <tr>
        <input type="hidden" id="username" name="username" value="{{$user->username}}">
        <th align="left" width="150" class="gray">組織</th>
        <td>{{$user->organization}}</td>
      </tr>
      <tr>
        <th align="left" class="gray">メールアドレス</th>
        <td><input type="email" name="email" size="20" value="{{$user->email}}"></td>
      </tr>
      <tr>
        <th align="left" class="gray">新しいパスワード</th>
        <td><input type="password" id="password" name="password" placeholder="新パスワード"></td>
      </tr>
      <tr>
        <th align="left" class="gray">新しいパスワード(確認用)</th>
        <td><input type="password" id="password_confirmation" name="password_confirmation" placeholder="新パスワード(確認用)"></td>
      </tr>
      <tr>
        <th class="gray"></th>
        <td colspan="3"><input type="submit" name="submit" value="更新"></td>
      </tr>
    </table>
  </div>
</form>
@stop
