@extends('layout.default')
@section('content')
<div class="page-header">
  <h3>管理者アカウント</h3>
</div>
@if(!$is_admin)
<button type="button" onclick="history.back()">戻る</button>
@else
<button type="button" onclick="location.href='{{URL::to('/scvmanager/scvconf')}}'">戻る</button>
<button onclick="location.href='{{URL::to('/scvmanager/users/create')}}'">作成</button>
<button onclick="location.href='{{URL::to('/scvmanager/adminpolicy')}}'">管理者パスワードポリシー</button>
@endif
<form action="{{URL::to('/scvmanager/users/create')}}" method="POST">
  <input type="hidden" name="_token" value="{{ csrf_token() }}">
  <div class="table-responsive">
    <table id="users" class="table table-condensed table-bordered">
    <thead>
      <tr>
        <td>ユーザネーム</td>
        <td>組織</td>
        <td>Eメール</td>
        <td>登録日</td>
        <td>更新日</td>
      </tr>
    </thead>
    <tbody>
    <?php foreach($users as $user){ ?>
      <tr>
        <td><a style="display:block" href="{{URL::to('/scvmanager/users/')}}/{{$user->username}}"> {{ $user->username }}</a></td>
        <td>{{ $user->name or "無し" }}</td>
        <td>{{ $user->email }}</td>
        <td>{{ $user->created_at }}</td>
        <td>{{ $user->updated_at }}</td>
      </tr>
    <?php } ?>
    </tbody>
    </table>
  </div>
</form>
@stop
