<!-- scv/resources/views/users/show.blade.php -->
@extends('layout.default')
@section('content')
<div class="page-header">
  <h3>アカウント詳細</h3>
</div>

@if(Session::has('flash_msg'))
  {!! Session::get('flash_msg') !!}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
<?php
 if(isset($msg)){ echo $msg; } ?>

<form action="{{URL::to('/scvmanager/users/')}}/{{$user->id}}" method="POST">
<input type="hidden" name="_method" value="DELETE">
<input type="hidden" name="_token" value="{{csrf_token()}}">
<input type="hidden" name="id" value="{{$user->id}}">
<input type="hidden" name="username" value="{{$user->username}}">
<button type="button" onclick="location.href='{{URL::to('/scvmanager/users')}}'">戻る</button>
<button type="button" onclick="location.href='/scvmanager/users/{{$user->username}}/edit/'">編集</button>
@if ($is_admin)
  <input type="submit" name="remove" onclick="return check();" value="削除">
@endif

<div class="table-responsive">
  <table class="table table-condensed table-bordered">
  <tbody>
    <tr>
      <th align="left" width="150" class="gray">ユーザ</th>
      <td>{{$user->username}}</td>
      <th align="left" width="150" class="gray">組織</th>
      <td>{{$user->organization}}</td>
    </tr>
    <tr>
      <th align="left" width="150" class="gray">Eメール</th>
      <td>{{$user->email}}</td>
      <th class="gray"></th>
      <td></td>
    </tr>
    <tr>
      <th align="left" width="150" class="gray">登録日</th>
      <td>{{ $user->created_at }}</td>
      <th align="left" width="150" class="gray">更新日</th>
      <td>{{ $user->updated_at }}</td>
    </tr>
  </tbody>
  </table>
</div>
</form>
@endsection
@section('script')
<script type="text/javascript">

  function check(){
    if('{{$user->username}}' == 'admin'){
      alert('adminは削除できません');
      return false;
    }

    if(confirm("{{$user->username}}を削除しますか？")){
      return true;
    }else{
      return false;
    }
  }
</script>
@endsection

