<!-- scv/resources/views/visionprof/create.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/wallpaper_settings.css') !!}">
  <link rel="stylesheet" href="{!! asset('css/scvmanager/visionprof.css') !!}">
@endsection

@section('content')

<div class="page-header">
  <h3>デスクトップ設定作成<span class="revodt-icon"></span></h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button onclick="location.href='{{URL::to('/scvmanager/visionprof')}}'">戻る</button>

{{ Form::open(['url' => '/scvmanager/visionprof', 'method' => 'post']) }}

<table id="visionprof" class="table table-condensed table-bordered">
  <tr>
    <th class="gray">設定名 <span style="color: red">*</span></th>
    <td>{{ Form::text('name', old('name'), ['required' => 'required']) }}</td>
  </tr>
  <tr>
    <th class="gray">ボリュームサイズ
      <span id="visionprof-volume-size"></span>
    </th>
    <td>{{ Form::number('volume_mb', 100, ['required' => 'required', 'min' => 100, 'max' => $volume_max]) }} MB</td>
  </tr>
  <tr>
    <th class="gray">許可アプリ設定<span style="color: red">*</span></th>
    <td>
      <table id="applist">
        <tr>
          <td>
            許可アプリ<br>
            <select id="left_list" size="5" multiple="multiple">
              @if(session('allowed_apps'))
                @foreach (session('allowed_apps') as $allowed_app)
                  <option value="{{ $allowed_app }}">{{ $allowed_app }}</option>
                @endforeach
              @endif
            </select>
          </td>
          <td>
            <input type="button" id="to_left" value="≪">
            <br><br>
            <input type="button" id="to_right" value="≫">
          </td>
          <td>
            アプリ一覧<br>
            <select id="right_list" size="5" multiple="multiple">
              @if(session('denied_apps') || session('backed'))
                @foreach (session('denied_apps') as $denied_app)
                  <option value="{{ $denied_app }}">{{ $denied_app }}</option>
                @endforeach
              @else
                @foreach ($visionprofile->supported_app_array as $name)
                  <option value="{{ $name }}">{{ $name }}</option>
                @endforeach
              @endif
            </select>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <th class="gray">
      デスクトップショートカット設定
      <span id="shortcut-settings-tooltip"></span>
    </th>
    <td>
      <select id="shortcut_settings_select">
        <option>選択してください</option>
      </select>
      <ul id="shortcut_settings_name" class="list-group">
      </ul>
    </td>
  </tr>
  <tr>
    <th class="gray">VPN設定<br>
      <div id='old_vpn_settings_link'>
        <a href='#'>旧VPN設定</a>
        <span id="old-vpn-settings-tooltip"></span>
      </div>
    </th>
    <td id="vpn_settings_td">
      {{ Form::select('vpn_settings_select', $vpn_settings->pluck('name', 'id')->prepend('選択してください', '0'), 0, ['id' => 'vpn_settings_select']) }}
      <span id="vpn-settings-tooltip"></span>
      <br>
      <ol id="vpn_settings_name" class='list-group'></ol>
    </td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNサーバアドレス(ローカル)
        <span id="visionprof-vpn-ipaddr"></span>
    </th>
    <td>{{ Form::text('vpn_ipaddr', old('vpn_ipaddr'),["placeholder"=>"例) 192.168.1.100"]) }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNサーバアドレス(グローバル)
        <span id="visionprof-global-vpn-ipaddr"></span>
    </th>
    <td>{{ Form::text('global_vpn_ipaddr', old('global_vpn_ipaddr'),["placeholder"=>"例) 52.52.52.168:15000"]) }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNインターフェース名</th>
    <td>{{ Form::text('vpn_nic_name', old('vpn_nic_name'),["placeholder"=>"wg0"]) }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">DNSサーバアドレス</th>
    <td>{{ Form::text('dns_server_ipaddr', old('dns_server_ipaddr'), ["placeholder"=>"例) 8.8.8.8"]) }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">許可ホスト</th>
    <td>{{ Form::textarea('allowed_hosts', old('allowed_hosts'),["placeholder"=>"例) 192.168.50.1\r\n例) 192.168.50.10"]) }}</td>
  </tr>
  <tr>
    <th class="gray">共有フォルダ</th>
    <td>
      <select name="shareprofile_id">
        <option value="0" selected>なし</option>
        @foreach($shareprofiles as $sp)
          <option value="{{$sp->id}}">{{$sp->org_name}}/{{$sp->shname}}</option>
        @endforeach
      </select>
    </td>
  </tr>
  <tr>
    <th class="gray">プロキシ設定</th>
    <td>
      <select name="proxy_setting_id">
        <option value="0">なし</option>
        @foreach($proxysettings as $ps)
          <option value="{{$ps->id}}" @if($ps->id == $visionprofile->proxy_setting_id) selected @endif>{{$ps->name}}</option>
        @endforeach
      </select>
    </td>
  </tr>
  <tr>
    <th class="gray">壁紙</th>
    <td>
      {{ Form::hidden('wallpaper_id', old('wallpaper_id', $visionprofile->wallpaper_id)) }}
      <div class="revo-wp-container">
        @foreach($wallpapers as $wallpaper)
          <div revo-wp-id="{{ $wallpaper->id }}" class="revo-wp-box revo-clktgt">
            <div class="revo-wp-box-thumbnail revo-wp-center">
              @if($wallpaper->fileUrl)
                <img class="revo-wp-thumbnail" src="{{ $wallpaper->fileUrl }}" alt="{{ $wallpaper->filename }}">
              @endif
            </div>
            <div class="revo-wp-box-text revo-wp-center">
              {{ $wallpaper->filename }}
            </div>
          </div>
        @endforeach
      </div>
    </td>
  </tr>
</table>
{{ Form::hidden('allowed_apps') }}
{{ Form::hidden('denied_apps') }}
{{ Form::submit('作成') }}
{{ Form::close() }}
@stop

@section('script')
<script>
  var tooltipParameters = {
    '#visionprof-volume-size': {
      'min': 100,
      'max': {{$volume_max}}
    }
  };
</script>
<script src="{!! asset('js/tooltips.js') !!}"></script>
<script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
<script src="{!! asset('js/scvmanager/visionprof.js') !!}"></script>
@stop
