<!-- scv/resources/views/visionprof/edit.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/wallpaper_settings.css') !!}">
  <link rel="stylesheet" href="{!! asset('css/scvmanager/visionprof.css') !!}">
@endsection

@section('content')

<div class="page-header">
  <h3>デスクトップ設定変更<span class="revodt-icon"></span></h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button onclick="location.href='{{URL::to('/scvmanager/visionprof')}}'">戻る</button>

{{ Form::open(['url' => '/scvmanager/visionprof/' . $visionprofile->id, 'method' => 'put', 'id' => 'save_visionprof']) }}
{{ Form::hidden('name', $visionprofile->name) }}
<table id="visionprof" class="table table-condensed table-bordered">
  <tr>
    <th class="gray">設定名</th>
    <td>{{$visionprofile->name}}</td>
  </tr>
  <tr>
    <th class="gray">ボリュームサイズ</th>
    <td>{{ $visionprofile->volume_mb }} MB</td>
  </tr>
  <tr>
    <th class="gray">許可アプリ設定<span style="color: red">*</span></th>
    <td>
      <table id="applist">
        <tr>
          <td>
            許可アプリ<br>
            <select id="left_list" size="5" multiple="multiple">
              @if(session('allowed_apps') || session('backed'))
                @foreach (session('allowed_apps') as $allowed_app)
                  <option value="{{ $allowed_app }}">{{ $allowed_app }}</option>
                @endforeach
              @else
                @foreach ($allowed_apps as $app)
                  <option value="{{ $app }}">{{ $app }}</option>
                @endforeach
              @endif
            </select>
          </td>
          <td>
            <input type="button" id="to_left" value="≪">
            <br><br>
            <input type="button" id="to_right" value="≫">
          </td>
          <td>
            アプリ一覧<br>
            <select id="right_list" size="5" multiple="multiple">
              @if(session('denied_apps'))
                @foreach (session('denied_apps') as $denied_app)
                  <option value="{{ $denied_app }}">{{ $denied_app }}</option>
                @endforeach
              @else
                @foreach ($denied_apps as $app)
                  <option value="{{ $app }}">{{ $app }}</option>
                @endforeach
              @endif
            </select>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <th class="gray">
      デスクトップショートカット設定
      <span id="shortcut-settings-tooltip"></span>
    </th>
    <td>
      <select id="shortcut_settings_select">
        <option value="default">選択してください</option>
        @if(session('allowed_apps') || session('backed'))
          @foreach (session('allowed_apps') as $allowed_app)
            <option value="{{ $allowed_app }}">{{ $allowed_app }}</option>
          @endforeach
        @else
          @foreach ($allowed_apps as $app)
            <option value="{{ $app }}">{{ $app }}</option>
          @endforeach
        @endif
      </select>
      <ul id="shortcut_settings_name" class="list-group">
        @foreach ($shortcut_list as $shortcut)
        <li class="list-group-item shortcuts" data-vs-id="{{$shortcut}}">{{$shortcut}}
          <button type="button" class="close vs-remove"><span>×</span></button>
        </li>
        <input type="hidden" name="shortcut_settings[{{$loop->iteration}}]" value="{{$shortcut}}" class="shortcut_settings_input">
        @endforeach
      </ul>
    </td>
  </tr>
  <tr>
    <th class="gray">VPN設定<br>
      <div id='old_vpn_settings_link'>
        <a href='#'>旧VPN設定</a>
        <span id="old-vpn-settings-tooltip"></span>
      </div>
    </th>
    <td id="vpn_settings_td">
      {{ Form::select('vpn_settings_select', $vpn_settings->pluck('name', 'id')->prepend('選択してください', '0'), 0, ['id' => 'vpn_settings_select', ]) }}
      <span id="vpn-settings-tooltip"></span>
      <ol id="vpn_settings_name" class='list-group'>
        @foreach ($visionprofile->vpnSettings as $vs)
        <li class="list-group-item" data-vs-id="{{$vs->id}}">{{$vs->name}}
          <button type="button" class="close vs-remove"><span>×</span></button>
        </li>
        <input type="hidden" name="vpn_settings[{{$vs->id}}]" value="{{$loop->iteration}}" class="vpn_settings_input">
        @endforeach
      </ol>
    </td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNサーバアドレス(ローカル)
        <span id="visionprof-vpn-ipaddr"></span>
    </th>
    <td>{{ Form::text('vpn_ipaddr', $visionprofile->vpn_ipaddr) }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNサーバアドレス(グローバル)
        <span id="visionprof-global-vpn-ipaddr"></span>
    </th>
    <td>{{ Form::text('global_vpn_ipaddr', $visionprofile->global_vpn_ipaddr) }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNインターフェース名</th>
    <td>{{ Form::text('vpn_nic_name', $visionprofile->vpn_nic_name) }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">DNSサーバアドレス</th>
    <td>{{ Form::text('dns_server_ipaddr', $visionprofile->dns_server_ipaddr) }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">許可ホスト</th>
    <td>{{ Form::textarea('allowed_hosts', $visionprofile->allowed_host_textarea) }}</td>
  </tr>
  <tr>
    <th class="gray">共有フォルダ</th>
    <td>
      <select name="shareprofile_id">
        <option value="0">なし</option>
        @foreach($shareprofiles as $sp)
          <option value="{{$sp->id}}" @if($sp->id == $visionprofile->shareprofile_id) selected @endif>{{$sp->org_name}}/{{$sp->shname}}</option>
        @endforeach
      </select>
    </td>
  </tr>
  <tr>
    <th class="gray">プロキシ設定</th>
    <td>
      <select name="proxy_setting_id">
        <option value="0">なし</option>
        @foreach($proxysettings as $ps)
          <option value="{{$ps->id}}" @if($ps->id == $visionprofile->proxy_setting_id) selected @endif>{{$ps->name}}</option>
        @endforeach
      </select>
    </td>
  </tr>
  <tr>
    <th class="gray">壁紙</th>
    <td>
      {{ Form::hidden('wallpaper_id', old('wallpaper_id', $visionprofile->wallpaper_id)) }}
      <div class="revo-wp-container">
        @foreach($wallpapers as $wallpaper)
          <div revo-wp-id="{{ $wallpaper->id }}" class="revo-wp-box revo-wp-box-clickable revo-clktgt">
            <div class="revo-wp-box-thumbnail revo-wp-center">
              @if($wallpaper->fileUrl)
                <img class="revo-wp-thumbnail" src="{{ $wallpaper->fileUrl }}" alt="{{ $wallpaper->filename }}">
              @endif
            </div>
            <div class="revo-wp-box-text revo-wp-center">
              {{ $wallpaper->filename }}
            </div>
          </div>
        @endforeach
      </div>
    </td>
  </tr>
</table>
{{ Form::hidden('allowed_apps') }}
{{ Form::hidden('denied_apps') }}
{{ Form::submit('変更') }}
{{ Form::close() }}
@stop

@section('script')
<script src="{!! asset('js/tooltips.js') !!}"></script>
<script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
<script src="{!! asset('js/scvmanager/visionprof.js') !!}"></script>
@stop