<!-- scv/resources/views/visionprof/index.blade.php -->
@extends('layout.default')
@section('content')
<div class="page-header">
  <h3>デスクトップ設定<span class="revodt-icon"></span></h3>
</div>

<p>RevoWorks Desktopの設定を管理します。</p>
@if (Session::has('success'))
  <p class="text-info">{!! Session::get('success') !!}</p>
@endif

<button onclick="location.href='{{URL::to('/scvmanager/scvgroups')}}'">戻る</button>
<button onclick="location.href='{{URL::to('/scvmanager/visionprof/create')}}'">作成</button>
<button onclick="location.href='{{ route('wallpaper.index') }}'">壁紙登録</button>
<div class="table-responsive">
  <table class="table table-condensed table-bordered table-striped">
    <tr>
      <th>id</th>
      <th>設定名</th>
      <th>ボリュームサイズ</th>
      {{-- 長いのでこのページでは省略 --}}
      {{-- <th>許可アプリ</th> --}}
      <th>サーバIP(ローカル)</th>
      <th>サーバIP(グローバル)</th>
      {{-- 長いので省略 --}}
      {{-- <th>許可ホスト</th> --}}
    </tr>
    @foreach ($visionprofiles as $visionprofile)
    <tr>
      <td>{{ $visionprofile->id }}</td>
      <td><a href="{{ URL::to('/scvmanager/visionprof') }}/{{ $visionprofile->id }}">{{ $visionprofile->name }}</a></td>
      <td>{{ $visionprofile->volume_mb }} MB</td>
      <td>{{ $visionprofile->vpn_ipaddr}}</td>
      <td>{{ $visionprofile->global_vpn_ipaddr}}</td>
    </tr>
    @endforeach
  </table>
</div>
@stop

@section('script')
<script>
</script>
@stop