<!-- scv/resources/views/visionprof/show.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/wallpaper_settings.css') !!}">
@endsection

@section('content')

<style>
form {
  display: inline;
}
table#visionprof tr th {
  width: 200px;
  white-space: nowrap;
}
table#visionprof input[type=text] {
  width: 200px;
}
table#visionprof textarea {
  width: 200px;
  height: 200px;
}
{{-- アプリを左右に移動させる部分 --}}
table#applist td {
  text-align: center;
}
table#applist select {
  width: 250px;
  height: 300px;
}
table#applist input[type=button] {
  margin: 0px 40px;
}
table#network input[type=button] {
  width: 50px;
  height: 30px;
}
</style>

<div class="page-header">
  <h3>デスクトップ設定詳細<span class="revodt-icon"></span></h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button onclick="location.href='{{URL::to('/scvmanager/visionprof')}}'">戻る</button>
<button onclick="location.href='/scvmanager/visionprof/{{ $visionprofile->id }}/edit'">編集</button>
{{ Form::open(['url' => "/scvmanager/visionprof/{$visionprofile->id}", 'method' => 'delete']) }}
  {{ Form::submit('削除', ['onclick'=>'return check();']) }}
{{ Form::close() }}

<table id="visionprof" class="table table-condensed table-bordered">
  <tr>
    <th class="gray">設定名</th>
    <td>{{ $visionprofile->name }}</td>
  </tr>
  <tr>
    <th class="gray">ボリュームサイズ</th>
    <td>{{ $visionprofile->volume_mb }} MB</td>
  </tr>
  <tr>
    <th class="gray">許可アプリ</th>
    <td>
      @foreach ($allowed_apps as $app)
        {{ $app }}<br>
      @endforeach
    </td>
  </tr>
{{--
  <tr>
    <th class="gray">拒否アプリ</th>
    <td>
      @foreach ($visionprofile->denied_app_array as $name)
        {{ $name }}<br>
      @endforeach
    </td>
  </tr>
--}}
  <tr>
    <th class="gray">デスクトップショートカット設定</th>
    <td>
      @foreach ($shortcut_list as $shortcut)
        {{ $shortcut }}<br>
      @endforeach
    </td>
  </tr>
  <tr>
    <th class="gray">VPN設定<br>
      <div id='old_vpn_settings_link'>
        <a href='#'>旧VPN設定</a>
      </div>
    </th>
    <td>
      @foreach ($visionprofile->vpnSettings as $vs)
        {{$loop->iteration}}.<a href="{{URL::to("/scvmanager/vpn_settings/$vs->id")}}">{{$vs->name}}</a>
        @if (!$loop->last)
        ,
        @endif
      @endforeach
    </td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNサーバアドレス(ローカル)</th>
    <td>{{ $visionprofile->vpn_ipaddr }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNサーバアドレス(グローバル)</th>
    <td>{{ $visionprofile->global_vpn_ipaddr }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">VPNインターフェース名</th>
    <td>{{ $visionprofile->vpn_nic_name }}</td>
  </tr>
  <tr class="old_vpn_settings">
    <th class="gray">DNSサーバアドレス</th>
    <td>{{ $visionprofile->dns_server_ipaddr }}</td>
  </tr>
  <tr>
    <th class="gray">許可ホスト</th>
    <td style="white-space: pre-line;">{{ $visionprofile->allowed_host_textarea }}</td>
  </tr>
  <tr>
    <th class="gray">共有フォルダ</th>
    <td>
      @if($shareprofile)
        <a href="{{URL::to("/scvmanager/share/{$shareprofile->id}")}}">{{ $shareprofile->org_name }}/{{ $shareprofile->shname }}</a>
      @else
        なし
      @endif
    </td>
  </tr>
  <tr>
    <th class="gray">プロキシ設定</th>
    <td>
      @if($proxySetting)
        <a href="{{URL::to("/scvmanager/proxy_settings/{$proxySetting->id}")}}">{{ $proxySetting->name }}</a>
      @else
        なし
      @endif
    </td>
  </tr>
  <tr>
    <th class="gray">壁紙</th>
    <td>
      @if($wallpaper->isDefault())
        {{ $wallpaper->filename }}
      @else
        <div class="revo-wp-container">
          <div class="revo-wp-box revo-wp-box-clickable" onclick="location.href='{{route('wallpaper.edit', ['id'=>$wallpaper->id])}}'">
            <div class="revo-wp-box-thumbnail revo-wp-center">
              @if($wallpaper->fileUrl)
                <img class="revo-wp-thumbnail" src="{{ $wallpaper->fileUrl }}" alt="{{ $wallpaper->filename }}">
              @endif
            </div>
            <div class="revo-wp-box-text revo-wp-center">
              {{ $wallpaper->filename }}
            </div>
          </div>
        </div>
      @endif
    </td>
  </tr>
</table>
@stop

@section('script')
<script>
  function check(){
    if(confirm("{{$visionprofile->name}}を削除しますか？")){
      return true;
    }else{
      return false;
    }
  }
</script>
<script src="{!! asset('js/scvmanager/visionprof.js') !!}"></script>
@stop
