<!-- scv/resources/views/vpn_settings/create.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/vpn_settings.css') !!}">
@endsection

@section('content')

  <div class="page-header">
    <h3>
      VPN設定作成
      <span class="revobr-icon"></span><span class="revodt-icon"></span>
    </h3>
  </div>


  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/vpn_settings') }}'">戻る</button>

  {{ Form::open(['action' => 'VpnSettingController@store']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名 <span style="color: red">*</span></th>
      <td>VPN_{{ Form::text('name', null, ['required' => 'required', 'id' => 'name_input']) }}</td>
    </tr>
    <tr>
      <th class="gray">VPNサーバアドレス(ローカル)
        <span style="color: red">*</span>
      </th>
      <td>
        {{ Form::text('local_address', null, ["placeholder"=>"例) 192.168.1.100", 'id' => 'local_address_input']) }}
        <span id="visionprof-vpn-ipaddr"></span>
      </td>
    </tr>
    <tr>
      <th class="gray">
        VPNサーバアドレス(グローバル)
        <span style="color: red">*</span>
      </th>
      <td>
        {{ Form::text('global_address', null, ["placeholder"=>"例) x.x.x.x:15000", 'id' => 'global_address_input']) }}
        <span id="visionprof-global-vpn-ipaddr"></span>
      </td>
    </tr>
    <tr>
      <th class="gray">VPNインターフェース名 <span style="color: red">*</span></th>
      <td>{{ Form::text('interface_name', null, ['required' => 'required', "placeholder"=>"例) wg0", 'id' => 'interface_input']) }}</td>
    </tr>
    <tr>
      <th class="gray">DNSサーバアドレス</th>
      <td>{{ Form::text('dns_servers', null, ["placeholder"=>"例) 8.8.8.8", 'id' => 'dns_servers_input']) }}</td>
    </tr>
    <tr>
      <th class="gray">許可ホスト <span style="color: red">*</span></th>
      <td>
        {{ Form::textarea('allowed_hosts', null, ['required' => 'required', 'placeholder' => "例) 192.168.50.1\r\n例) 192.168.50.10", 'id' => 'allowed_hosts_input']) }}
        <span id="allowed-hosts-tooltip"></span>
      </td>
    </tr>
  </table>
  {{ Form::submit('作成') }}
@stop

@section('script')
  <script src="{!! asset('js/tooltips.js') !!}"></script>
@stop
