<!-- scv/resources/views/vpn_settings/index.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/vpn_settings.css') !!}">
@endsection

@section('content')
  <div class="page-header">
    <h3>
      VPN設定
      <span class="revobr-icon"></span><span class="revodt-icon"></span>
    </h3>
  </div>

  <p>VPN設定を管理します。</p>
  @if (Session::has('success'))
    <p class="text-info">{!! Session::get('success') !!}</p>
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/scvgroups') }}'">戻る</button>
  <button onclick="location.href='{{ URL::to('/scvmanager/vpn_settings/create') }}'">作成</button>
  <div class="table-responsive">
    <table class="table table-condensed table-bordered table-striped">
      <tr>
        <th>id</th>
        <th>設定名</th>
        <th>VPNサーバアドレス(ローカル)</th>
        <th>VPNサーバアドレス(グローバル)</th>
        <th>I/F名</th>
        <th>DNS</th>
        <th>許可ホスト</th>
      </tr>
      @foreach ($settings as $s)
        <tr>
          <td>{{ $s->id }}</td>
          <td><a href="{{ URL::to("/scvmanager/vpn_settings/$s->id") }}">{{ $s->name }}</a></td>
          <td>{{ $s->local_address }}</td>
          <td>{{ $s->global_address }}</td>
          <td>{{ $s->interface_name }}</td>
          <td>{{ $s->dns_servers }}</td>
          <td id="allowed_hosts">{{ $s->allowed_hosts }}</td>
        </tr>
      @endforeach
    </table>
  </div>
@stop

@section('script')
  <script>
  </script>
@stop
