<!-- scv/resources/views/vpn_settings/show.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/vpn_settings.css') !!}">
@endsection

@section('content')

  <div class="page-header">
    <h3>
      VPN設定詳細<span class="revobr-icon"></span><span class="revodt-icon"></span>
    </h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  {{ Form::open(['url' => "/scvmanager/vpn_settings/{$setting->id}", 'method' => 'delete']) }}
  <button type="button" onclick="location.href='{{ URL::to('/scvmanager/vpn_settings') }}'">戻る</button>
  <button type="button" onclick="location.href='/scvmanager/vpn_settings/{{ $setting->id }}/edit'">編集</button>
  {{ Form::hidden('id', $setting->id) }}
  {{ Form::submit('削除', ['onclick' => 'return check();']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名</th>
      <td>{{ $setting->name }}</td>
    </tr>
    <tr>
      <th class="gray">VPNサーバアドレス(ローカル)</th>
      <td>{{ $setting->local_address }}</td>
    </tr>
    <tr>
      <th class="gray">VPNサーバアドレス(グローバル)</th>
      <td>{{ $setting->global_address }}</td>
    </tr>
    <tr>
      <th class="gray">VPNインターフェース名</th>
      <td>{{ $setting->interface_name }}</td>
    </tr>
    <th class="gray">DNSサーバアドレス</th>
    <td>{{ $setting->dns_servers }}</td>
    </tr>
    <tr>
      <th class="gray">許可ホスト</th>
      <td id="allowed_hosts">{{ $setting->allowed_hosts }}</td>
    </tr>
  </table>
@stop

@section('script')
  <script>
    $(function() {
      $("form").submit(function() {
        if (confirm("{{ $setting->name }}を削除しますか？")) {
          return true;
        } else {
          return false;
        }
      });
    });

  </script>
@stop
