<!-- scv/resources/views/wallpaper/edit.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/wallpaper_settings.css') !!}">
@endsection

@section('content')

<div class="page-header">
  <h3>壁紙設定<span class="revodt-icon"></span></h3>
</div>

@if(Session::has('err'))
  <p style="color:red;">{{session('err')}}</p>
@endif
@if(Session::has('success'))
  <p class="text-info">{{session('success')}}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

{{ Form::open([ 'url' => route('wallpaper.destroy', [ 'id' => $wallpaper->id ]), 'method' => 'delete' ]) }}
<button type="button" onclick="location.href='{{ old('from_url', url()->previous()) }}'">戻る</button>
{{ Form::hidden('from_url', old('redirect_to', url()->previous())) }}
{{ Form::submit('削除', [
  'name' => 'delete',
  'onclick' => "return confirmDelete();",
]) }}
{{ Form::close() }}

{{ Form::open([ 'url' => route('wallpaper.update', ['id'=>$wallpaper->id]), 'method' => 'put' ]) }}
<table class="table table-condensed table-bordered revo-wp-table">
  <tr>
    <th class="gray">画像</th>
    <td>
      <a href="{{ $wallpaper->fileUrl }}" target="_blank">
        <img id="wallpaper_image" src="{{ $wallpaper->fileUrl }}" alt="{{ $wallpaper->filename }}">
      </a>
    </td>
  </tr>
  <tr>
    <th class="gray">ファイル名</th>
    <td>{{ $wallpaper->filename }}</td>
  </tr>
  <tr>
    <th class="gray">画像サイズ</th>
    <td><span id="wallpaper_image_size"></span></td>
  </tr>
  <tr>
    <th class="gray">ファイルサイズ</th>
    <td>{{ number_format($wallpaper->size) }} バイト</td>
  </tr>
  <tr>
    <th class="gray">表示形式</th>
    <td>
      <select name="style">
        @foreach($styles as $name => $label)
          <option value="{{$name}}"
            @if($wallpaper->style === $name) selected
            @endif
          >{{$label}}
        @endforeach
      </select>
    </td>
  </tr>
  <tr>
    <th class="gray"></th>
    <td colspan="3"><input type="submit" name="submit" value="更新"></td>
  </tr>
</table>
{{ Form::close() }}

@endsection

@section('script')
<script type="text/javascript">
  $(window).load(function () {
    var $wp = $('#wallpaper_image');
    var $desc = $('#wallpaper_image_size');
    $desc.text($wp[0].naturalWidth + ' × ' + $wp[0].naturalHeight);
  });

  function confirmDelete() {
    if (confirm("{{$wallpaper->filename}} を削除しますか？")) {
      return true;
    } else {
      return false;
    }
  }
</script>
@endsection
