<!-- scv/resources/views/wallpaper/index.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/wallpaper_settings.css') !!}">
@endsection

@section('content')

<div class="page-header">
  <h3>壁紙登録<span class="revodt-icon"></span></h3>
</div>

@if(Session::has('err'))
  <p style="color:red;">{{session('err')}}</p>
@endif
@if(Session::has('success'))
  <p class="text-info">{{session('success')}}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button type="button" onclick="location.href='/scvmanager/visionprof'">戻る</button>

<div class="revo-wp-container">
  @foreach($wallpapers as $wallpaper)
    <div class="revo-wp-box revo-wp-box-clickable" onclick="location.href='{{route('wallpaper.edit', ['id'=>$wallpaper->id])}}'">
      <div class="revo-wp-box-thumbnail revo-wp-center">
        <img class="revo-wp-thumbnail" src="{{ $wallpaper->fileUrl }}" alt="{{ $wallpaper->filename }}">
      </div>
      <div class="revo-wp-box-text revo-wp-center">
        {{ $wallpaper->filename }}
      </div>
    </div>
  @endforeach
</div>

<div class="row">
  <div class="col-md-4">
    {{ Form::open([ 'url' => route('wallpaper.store'), 'files' => true, 'method' => 'post' ]) }}
    {{ Form::file('wallpaper')}}
    {{ Form::submit('アップロード', [ 'name' => 'upload' ])}}
    {{ Form::close() }}
  </div>
</div>
@endsection
