<?php

use Illuminate\Http\Request;

Route::get('/user', function(Request $request) {
    return $request->user();
})->middleware('auth:api');

/* * * * * * * * * *
    SCVX Flow用 API
 * * * * * * * * * */
Route::group(['prefix' => 'v1/scvflow'], function() {
    Route::group(['middleware' => 'guest:api'], function() {
        Route::post('get-sslmode',         'scvflow\ApiController@get_sslmode_post');
        Route::get('get-sslmode',          'scvflow\ApiController@get_sslmode_get');
        Route::post('get-master-address',  'scvflow\ApiController@get_master_address');
        Route::post('get-scvconf',         'scvflow\ApiController@get_scvconf');
        Route::post('login',               'scvflow\ApiController@login');
        Route::post('login-for-curl',      'scvflow\ApiController@login_for_curl');
        Route::post('debug-normal-upload', 'scvflow\ApiController@debug_normal_upload');
        Route::post('unauthenticated',     'scvflow\ApiController@unauthenticated');
    });
    Route::group(['middleware' => 'auth:api'], function() {
        Route::post('prior-info/{organization}/{applicant}', 'scvflow\ApiController@prior_info');
        Route::post('user2department/{organization}/{user}', 'scvflow\ApiController@user2department');  // client 4.1.83用
        Route::post('normal-upload' , 'scvflow\ApiController@normal_upload');
        Route::post('normal-download' , 'scvflow\ApiController@download_request');
        Route::get('get-downloadable-file/{user_id}' , 'scvflow\ApiController@get_downloadable_file_all');
        Route::get('get-downloadable-file/{user_id}/{action_type}' , 'scvflow\ApiController@get_downloadable_file');
        Route::get('list/{organization_name}/{username}/{action_type}' , 'scvflow\ApiController@get_downloadable_file_with_org');
        Route::get('files/{id}', 'scvflow\ApiController@file_download');
        //Route::post('chunk-upload-init' , 'scvflow\ApiController@chunk_upload_init');
        //Route::post('chunk-upload' , 'scvflow\ApiController@chunk_upload');
    });
});



/* * * * * * * * * *
    SCV Go 用 API
 * * * * * * * * * */
Route::get('v1/serverlist', 'ApiController@getServerlist');

/* * * * * * * * * *
    2要素認証用 API
 * * * * * * * * * */
Route::post('v1/gauth/login',     'scvapi\GAuthController@login');
Route::post('v1/gauth/qr-base64', 'scvapi\GAuthController@qr_base64');

// ヘルスチェックAPI
Route::get('v1/health_check', 'ApiController@healthCheck');

// デバッグ用
Route::get('v1/debug/postme/form',  'scvapi\PostMeController@form');
Route::post('v1/debug/postme/form', 'scvapi\PostMeController@form');
Route::get('v1/debug/postme/json',  'scvapi\PostMeController@json');
Route::post('v1/debug/postme/json', 'scvapi\PostMeController@json');

Route::get('v1/test', function(){
    echo "test ok";
});
