<?php

// prefix:revobr/api
Route::group(['prefix' => 'v1'], function() {

  //バージョン取得
  Route::get('client/version', 'revobr\RevoBrCommonController@version');
  //指定されたバージョンをDLする
  Route::get('download/client', 'revobr\RevoBrCommonController@download');
  Route::get('download/updater', 'revobr\RevoBrCommonController@download');
  Route::get('download/firefox', 'revobr\RevoBrCommonController@download');
  Route::get('download/chrome', 'revobr\RevoBrCommonController@download');
  Route::get('download/extension', 'revobr\RevoBrCommonController@download');
  //updateログ
  Route::post('updatelog', 'revobr\RevoBrCommonController@updateLog');
  //クライアントDLリンク
  Route::get('downloads/client/{version}', 'revobr\RevoBrCommonController@download');
  //単数形に変更
  Route::get('download/client/{version}', 'revobr\RevoBrCommonController@download');
  //アップデートポリシー
  Route::post('update_policy', 'revobr\RevoBrCommonController@policy');

  //ログイン関連
  Route::post('auth', 'Api\CommonController@login');
  Route::get('auth/{long_ip}', 'Api\ConfigController@authmode');
  Route::post('flow/auth', 'scvflow\ApiController@login');

  //GAUTH関連
  Route::post('gauth/status', 'Api\GAuthController@status');
  Route::post('gauth/qr', 'Api\GAuthController@getQr');
  Route::post('gauth', 'Api\GAuthController@login');

  Route::get('sav/etag', 'Api\CommonController@getSavEtags');
  Route::get('sav/ide', 'Api\CommonController@getIdeFile');
  Route::get('sav/vdl', 'Api\CommonController@getVdlFile');
  Route::get('sav/win64/engine', 'Api\CommonController@getWin64Engine');
  Route::get('sav/win32/engine', 'Api\CommonController@getWin32Engine');

  //トークンが必要なAPI
  Route::group(['middleware' => 'auth:revobr_api'], function() {

    //コンテナ操作
    Route::resource('container', 'revobr\ContainerController');

    //各種リミットチェック
    Route::get('stz/limit', 'Api\CommonController@stzlimit');
    Route::get('vck/limit', 'Api\CommonController@vcklimit');
    Route::get('tck/limit', 'Api\CommonController@tcklimit');

    Route::get('profiles/firefox/{id}', 'revobr\ProfileController@download');
    Route::post('profiles/firefox/{id}', 'revobr\ProfileController@upload');
    //単数形にしたかったので、同じようなルーティング追加（v2で整理する）
    Route::get('profile/firefox/{id}', 'revobr\ProfileController@download');
    Route::post('profile/firefox/{id}', 'revobr\ProfileController@upload');
    
    Route::get('settings/browser/{id}', 'revobr\RevoBrCommonController@getSettings');
    Route::get('settings/firefox/{id}', 'revobr\RevoBrCommonController@getSettings');

    Route::get('profile/chrome/{id}', 'revobr\ProfileController@download');
    Route::post('profile/chrome/{id}', 'revobr\ProfileController@upload');

    Route::get('profile/edge/{id}', 'revobr\ProfileController@download');
    Route::post('profile/edge/{id}', 'revobr\ProfileController@upload');

    //ファイルログ挿入
    Route::post('filelogs', 'Api\CommonController@filelog');
    //単数形
    Route::post('filelog', 'Api\CommonController@filelog');

    Route::get('tck/reports/{sha256}', 'Api\TckController@getSandboxReport');
    Route::post('tck/files', 'Api\TckController@sendFile');
    Route::get('tck/jobs/{id}', 'Api\TckController@getJobs');

    Route::post('notices/threats', 'Api\CommonController@threatNotification');

    /* * * * * * * * * * * * * * * * * * * * *
        Flow用API(API再設計に伴い暫定的に実装)
     * * * * * * * * * * * * * * * * * * * * */
    Route::group(['middleware' => 'auth:api'], function () {
        Route::post('prior-info/{organization}/{applicant}', 'scvflow\ApiController@prior_info');
        // 互換性維持のため暫定的に配置
        Route::post('flow/files' , 'scvflow\ApiController@download_request');
        Route::post('flow/files/upload' , 'scvflow\ApiController@normal_upload');
        Route::post('flow/files/download' , 'scvflow\ApiController@download_request');
        Route::get('flow/files/{id}' , 'scvflow\ApiController@file_download');
        Route::get('flow/list/{user_id}' , 'scvflow\ApiController@get_downloadable_file_all');
        Route::get('flow/list/{user_id}/{action_type}' , 'scvflow\ApiController@get_downloadable_file');
        Route::get('flow/list/{organization_name}/{username}/{action_type}' , 'scvflow\ApiController@get_downloadable_file_with_org');
    }); 
  });
});
