<?php

use Illuminate\Http\Request;

/* * * * * * * * * *
    RevoDesktop用 API
 * * * * * * * * * */

// prefix:revodt/api
Route::group(['prefix' => 'v1'], function() {
    Route::post('set-client-infos', 'revodt\RevodtApiController@set_client_infos');
    Route::post('get-available-apps', 'revodt\RevodtApiController@get_available_apps');

    Route::post('auth', 'Api\CommonController@login');
    Route::group(['middleware' => 'auth:revodt_api'], function(){

        Route::post('app/installed', 'revodt\RevodtApiController@saveClientApps');
        Route::get('app/allowed', 'revodt\RevodtApiController@getAllowedApps');

        Route::put('desktop', 'revodt\RevodtApiController@updateDesktopStatus');
        Route::get('desktop/settings', 'revodt\RevodtApiController@getDesktopSettings');

        Route::resource('container', 'revodt\RevodtContainerController');

        //シークレットファイル
        Route::resource('secret', 'revodt\RevodtSecretController');

        //各種リミットチェック
        Route::get('stz/limit', 'Api\CommonController@stzlimit');
        Route::get('vck/limit', 'Api\CommonController@vcklimit');
        Route::get('tck/limit', 'Api\CommonController@tcklimit');

        //tck
        Route::get('tck/reports/{sha256}', 'Api\TckController@getSandboxReport');
        Route::post('tck/files', 'Api\TckController@sendFile');
        Route::get('tck/jobs/{id}', 'Api\TckController@getJobs');

        Route::post('notices/threats', 'Api\CommonController@threatNotification');

        //ファイルログ挿入
        Route::post('filelog', 'Api\CommonController@filelog');
        Route::post('filelogs', 'Api\CommonController@filelog');

        // デスクトップ壁紙
        Route::get('wallpaper/file/{id}', 'WallpaperDownloadController@download')->name('api.wallpaper.file');
        Route::get('wallpaper/json/{id}', 'WallpaperDownloadController@downloadAsJson')->name('api.wallpaper.json');
    });
/* * * * * * * * * * * * * * * * * * * * *
    Flow用API(API再設計に伴い暫定的に実装)
 * * * * * * * * * * * * * * * * * * * * */
   Route::group(['middleware' => 'auth:api'], function () {
        Route::post('prior-info/{organization}/{applicant}', 'scvflow\ApiController@prior_info');
        // 互換性維持のため暫定的に配置
        Route::post('flow/files' , 'scvflow\ApiController@download_request');
        Route::post('flow/files/upload' , 'scvflow\ApiController@normal_upload');
        Route::post('flow/files/download' , 'scvflow\ApiController@download_request');
        Route::get('flow/files/{id}' , 'scvflow\ApiController@file_download');
        Route::get('flow/list/{user_id}' , 'scvflow\ApiController@get_downloadable_file_all');
        Route::get('flow/list/{user_id}/{action_type}' , 'scvflow\ApiController@get_downloadable_file');
        Route::get('flow/list/{organization_name}/{username}/{action_type}' , 'scvflow\ApiController@get_downloadable_file_with_org');
   }); 
});
