<?php
/***************************/
/*     saml連携用ページ     */
/***************************/
Route::get('scvxsaml/response', 'SamlController@showSamlResponse');
/***************************/
/* 認証必要なページのグループ */
/***************************/
Route::group(['prefix' => 'scvmanager', 'name' => 'manager'], function(){
  Route::get('login', 'Auth\LoginController@showLoginForm')->name('login');
  Route::post('login', 'Auth\LoginController@login');
  Route::get('logout', 'Auth\LoginController@logout');

  Route::group(['middleware' => 'auth'], function () {
    Route::get('users/{name}/edit', 'UsersController@edit')->middleware('exclusive_control');;
    Route::patch('users/{id}', 'UsersController@update')->middleware('exclusive_control');;

    /* Reports */
    Route::resource('reports',    'ReportsController');
    Route::resource('reportrank', 'ReportrankController');
    Route::group(['middleware' => 'can:super-admin'], function(){
      Route::resource('reportutil', 'ReportutilController');
      Route::resource('reportperf', 'ReportperfController');

      Route::get('logsearch', 'LogSearchController@logindex');
      Route::post('logsearch', 'LogSearchController@logsearch');

      Route::get('filelogsearch', 'LogSearchController@filelogindex');
      Route::post('filelogsearch', 'LogSearchController@filelogsearch');

      Route::get('updater_log', 'LogSearchController@updaterlogIndex');
      Route::post('updater_log', 'LogSearchController@updaterlogSearch');
      Route::post('updater_log/csv', 'LogSearchController@updaterlogCsv');
    });
  });
 
  //排他制御を行うグループ
  Route::group(['middleware' => ['auth', 'can:nomal-login', 'exclusive_control']], function () {
    /* Home */
    Route::get('/', 'HomeController@index');
    Route::resource('home', 'HomeController');
    Route::get('ajax', 'HomeController@ajax');

    //クラスタ
    Route::get('cluster/containers', 'ClusterController@containers');
    Route::resource('cluster', 'ClusterController');
    Route::post('cluster/search', 'ClusterController@search');
    Route::post('servers_ajax','ClusterController@servers_ajax');

    /* Organization */
    Route::resource('organization', 'OrganizationController');

    /* Scvgroups */
    Route::get('scvgroups/csv', 'ScvgroupsController@csv');
    Route::get('scvgroups/csv_download', 'ScvgroupsController@csv_download');
    Route::post('scvgroups/csv_upload', 'ScvgroupsController@csv_upload');
    Route::resource('scvgroups', 'ScvgroupsController');
    
    /* ProfileGroup */
    Route::resource('profile_group', 'ProfileGroupController');

    Route::group(['middleware' => ['can:super-admin']], function () {
      /* Scvconf */
      Route::resource('scvconf', 'ScvconfController');

      /* Account */
      // Route::resource('account', 'AccountController');

      // Container
      Route::resource('container', 'ContainerController');
      Route::post('container', 'ContainerController@remove');
      Route::post('cpuajax', 'ContainerController@cpuajax');

      // Emergency Mode
      Route::get('emergency_mode','EmergencyModeController@index');
      Route::get('emergency_mode/create','EmergencyModeController@create');
      Route::post('emergency_mode/store','EmergencyModeController@store');
    });

    // LDAP設定
    // 親パス 'scvusers' を使用するユーザ管理より前に書かないと認識されない
    Route::resource('scvusers/ldaps', 'LdapSettingController');
    Route::get('scvusers/ldapsearch/{id}', 'LdapSettingController@ldapSearch'); // 検索
    Route::post('scvusers/ldapsearch/{id}', 'LdapSettingController@ldapStore');  // 検索結果反映

    // ユーザ管理
    Route::resource('scvusers', 'ScvusersController');
    Route::get('search','ScvusersController@search');

    /* EditUserPasswd */
    Route::resource('edit_user_passwd', 'EditUserPasswdController');

    // 管理アカウント
    // Route::resource('users', 'UsersController');
    Route::get('users', 'UsersController@index');
    Route::get('users/create', 'UsersController@create');
    Route::get('users/{name}', 'UsersController@show');
    Route::post('users', 'UsersController@store');
    Route::delete('users/{id}', 'UsersController@destroy');

    // 管理者パスワードポリシー
    Route::get('adminpolicy', 'AdminPolicyController@index');
    Route::get('adminpolicy/create', 'AdminPolicyController@create');
    Route::get('adminpolicy/show/{id}', 'AdminPolicyController@show');
    Route::get('adminpolicy/edit/{id}', 'AdminPolicyController@edit');
    Route::get('adminpolicy/delete/{id}', 'AdminPolicyController@delete');
    Route::post('adminpolicy/update', 'AdminPolicyController@update');
    Route::post('adminpolicy/store', 'AdminPolicyController@store');

    //ユーザ一括処理
    Route::get('batch/csv', 'BatchEditController@csv');
    Route::post('batch/upload', 'BatchEditController@upload');
    Route::resource('batch', 'BatchEditController');

    //firefoxprofile設定
    Route::resource('firefoxprof', 'FirefoxProfController');
    Route::post('firefoxprof/search', 'FirefoxProfController@search');
    Route::get('firefoxprof/cert/show/{id}', 'FirefoxProfController@certShow');
    Route::post('firefoxprof/cert/upload', 'FirefoxProfController@certSave');
    Route::post('firefoxprof/cert/delete', 'FirefoxProfController@certDelete');

    // RevoBrowser設定
    Route::resource('br_settings', 'BrSettingController');
    // Chrome設定
    Route::resource('chrome_settings', 'ChromeSettingController');
    // Edge設定
    Route::resource('edge_settings', 'EdgeSettingController');
    // Bookmark設定
    Route::resource('managed_bookmarks', 'ManagedBookmarkController');

    // SCVX-Chrome設定
    Route::resource('scvx_chrome_settings', 'ScvxChromeSettingController');
    Route::get('scvx_chrome_settings/cert/show/{id}', 'ScvxChromeSettingController@certShow');
    Route::post('scvx_chrome_settings/cert/upload', 'ScvxChromeSettingController@certSave');
    Route::post('scvx_chrome_settings/cert/delete', 'ScvxChromeSettingController@certDelete');

    // VPN設定
    Route::resource('vpn_settings', 'VpnSettingController');

    // Proxy設定
    Route::resource('proxy_settings', 'ProxySettingController');

    //RevoDesktop設定
    Route::resource('visionprof', 'VisionprofController');

    //共有フォルダ設定
    Route::resource('share', 'ShareController');

    Route::group(['middleware' => ['can:super-admin']], function () {

      // 端末管理
      Route::resource('devices/', 'DevicesController');
      Route::post('devices/revobr/policy_sort', 'revobr\UpdatePolicyController@sort');
      Route::resource('devices/revobr/policy', 'revobr\UpdatePolicyController');
      Route::resource('devices/revobr/upload', 'revobr\ClientUpdateController');
      Route::resource('devices/revodt_list', 'RevodtListController');
      Route::post('devices/revodt_list/search', 'RevodtListController@search');

      // RevoBrowser設定
      Route::resource('br_settings', 'BrSettingController');

      // Chrome設定
      Route::resource('chrome_settings', 'ChromeSettingController');

      // Edge設定
      Route::resource('edge_settings', 'EdgeSettingController');

      // Bookmark設定
      Route::resource('managed_bookmarks', 'ManagedBookmarkController');

      // Proxy設定
      Route::resource('proxy_settings', 'ProxySettingController');

      //RevoDesktop設定
      Route::resource('visionprof', 'VisionprofController');

      // 壁紙登録
      Route::resource('wallpaper', 'WallpaperController');

      // 壁紙ダウンロード
      Route::get('wallpaper/file/{id}', 'WallpaperDownloadController@download')->name('wallpaper.file');

      // VPN設定
      Route::resource('vpn_settings', 'VpnSettingController');

      //アプリケーションマスタ設定
      Route::get('appsettings', 'AppSettingController@index');
      Route::get('appsettings/show', 'AppSettingController@show');
      Route::get('appsettings/edit', 'AppSettingController@edit');
      Route::post('appsettings/store', 'AppSettingController@store');

      // アプリケーションパス設定
      Route::get('apppath/edit/{id}', 'AppPathController@edit');
      Route::post('apppath/store', 'AppPathController@store');

      //ライセンスアップロード
      Route::get('scvxlicense/list', 'LicenseController@getList');
      Route::post('scvxlicense/upload', 'LicenseController@upload');
      Route::post('scvxlicense/delete', 'LicenseController@delete');
      Route::resource('scvxlicense', 'LicenseController');

      //PAC
      Route::resource('pac', 'PacController');

      // URLホワイトリスト
      Route::resource('serverlist', 'ServerListController');

    });

    /* Managed */
    Route::resource('managed', 'ManagedController');
    Route::get('checkConnection', 'ManagedController@checkConnection');
    Route::get('newConnection', 'ManagedController@newConnection');
    Route::get('removeConnection', 'ManagedController@removeConnection');

    // パスワードポリシー管理
    Route::resource('password_policy', 'PasswordPolicyController');

    // PPU設定
    Route::resource('ppu', 'PpuController');

    // Download Route
    Route::get('download/{filename}', function($filename)
    {
      // Check if file exists in app/storage/file folder
      $file_path = storage_path() .'/kits/'. $filename;
      if (file_exists($file_path)){
        // Send Download
        return Response::download($file_path, $filename, [
          'Content-Length: '. filesize($file_path)
        ]);
      }else{
        // Error
        exit('Requested file does not exist on our server!');
      }
    })->where('filename', '[A-Za-z0-9\-\_\.]+');
  });

  // Laravelのログを表示するデバッグ用のページ
  Route::get('laravellog', 'LaravelLogController@index');

});

/***************************/
/*     認証不要なページ     */
/***************************/
Route::get('about',           'AboutController@index')->middleware('auth')->middleware('can:super-admin');
// Route::get('contact',         'ContactController@index');
Route::get('about_license',         'AboutController@license_index')->middleware('auth')->middleware('can:super-admin');
// Route::get('scvclient_help',  'ScvclientHelpController@index');
// Route::get('scvmanager_help', 'ScvmanagerHelpController@index');
// Route::get('notyet',          'NotyetController@index');

/* UserAccount */
Route::get('user_account/{org}/{user}/{ip_int}', 'UserAccountController@index');
Route::post('user_account/{org}/{user}/{ip_int}', 'UserAccountController@store');

// Password reset link request routes...
// Route::get('password/email', 'Auth\PasswordController@getEmail');
// Route::post('password/email', 'Auth\PasswordController@postEmail');
// Password reset routes...
// Route::get('password/reset/{token}', 'Auth\PasswordController@getReset');
// Route::post('password/reset', 'Auth\PasswordController@postReset');


/***************************/
/*     SCV Flow (Scvuserでのログイン)     */
/***************************/

Route::group(['prefix' => 'scvflow'], function() {

  Route::get('login', 'scvflow\LoginController@showLoginForm')->name('scvflow.login');
  Route::post('login', 'scvflow\LoginController@authenticate');
  Route::get('logout', 'scvflow\LoginController@logout');

  Route::group(['middleware' => 'auth:scvuser'], function () {

    // SCVFlowトップ
    Route::get('', 'scvflow\RequestsCommonController@index')->name('scvflow.home');

    // 自分が行った申請一覧
    Route::get('applicant', 'scvflow\RequestsCommonController@applicant_index');
    Route::post('applicant', 'scvflow\RequestsCommonController@applicant_store');

    // 自分宛ての申請一覧
    Route::get('authorizer', 'scvflow\RequestsCommonController@authorizer_index');
    Route::post('authorizer', 'scvflow\RequestsCommonController@authorizer_store');

    // 申請の個別ページ（プレビュー）
    Route::get('auth/{dl_key}', 'scvflow\AuthRequestController@index');
    Route::post('auth/{dl_key}', 'scvflow\AuthRequestController@store');

    //Flowダウンロード申請
    Route::get('request/download/create', 'scvflow\FlowDownloadRequestController@create');
    Route::post('request/download', 'scvflow\FlowDownloadRequestController@store');
  });

  // 原本ファイルへのリンク（承認済でないと管理者しかアクセスできない）
  Route::get('download/{dl_key}', 'scvflow\DownloadController@index');
  // プレビュー用のMIMEを追加したもの。IEは適切なMIMEが設定されていないと表示に失敗する
  Route::get('download/preview/{dl_key}', 'scvflow\DownloadController@preview');

});

Route::get('debug/qr/{org}/{user}', 'ScvLoginController@debug_qr');

// QRコードを表示するページ
Route::get('user_gauth_setup/{org}/{user}/{otpwd}', 'scvapi\GAuthController@user_gauth_setup');

