#!/bin/bash
#scvrelocate 2020/06/19
#Copyright J's Communication Co., Ltd.
#========================================
PROGNAME="scvrelocate"
PROGVER="1.1"

work=`mktemp -d "/tmp/sav_XXXX"`

version=`cat /tmp/virusDataVersion.txt`

if [ "$1" = "ide" ];then
  unzip /tmp/ide_${version}.zip -d $work
  cp -p $work/* /usr/local/sav/sav/
  
  chown -R www-data:docker /var/www/html/scv/sav/

  rm /tmp/ide_${version}.zip
  rm -rf $work

elif [ "$1" = "engine" ];then
  SAVLIB=`ls /tmp/libsavi.so.*`
  LIBDIR="/usr/local/sav/lib"
  LIBNAME=`basename ${SAVLIB}`
  LIBPATH="${LIBDIR}/${LIBNAME}"
  rm ${LIBDIR}/libsavi.so.*
  rm  /usr/local/lib/libsavi.so.*
  cp ${SAVLIB} ${LIBDIR}
  cp /tmp/engineVersion.txt /var/www/html/scv/sav/
  chown www-data:docker /var/www/html/scv/sav/engineVersion.txt
  ln -fs ${LIBPATH} "${LIBDIR}/libsavi.so"
  ln -fs ${LIBPATH} "${LIBDIR}/libsavi.so.2"
  ln -fs ${LIBPATH} "${LIBDIR}/libsavi.so.3"
  # sweepコマンド用
  ln -fs ${LIBPATH} /usr/local/lib/libsavi.so
  ln -fs ${LIBPATH} /usr/local/lib/libsavi.so.2
  ln -fs ${LIBPATH} /usr/local/lib/libsavi.so.3

  rm -rf $work
  rm $SAVLIB
  rm  /tmp/engineVersion.txt

else

  unzip /tmp/vdl.zip -d $work
  
  rm -rf /usr/local/sav/sav/*
  cp -p $work/* /usr/local/sav/sav/
  
  cp /tmp/virusDataVersion.txt /var/www/html/scv/sav/
  chown -R www-data:docker /var/www/html/scv/sav/
  
  rm /tmp/vdl.zip
  rm -rf $work
fi
