#!/bin/bash
#--------------------------------------------
#scvsetup.sh for scvbin's commands
#2020/05/03
#シンボリックリンクを作成
#--------------------------------------------
setup(){
  for PROG in $PROGS; do
    echo "setting up $PROG[$1]..."
    if [ -e /usr/local/bin/$PROG ]; then
      sudo rm /usr/local/bin/$PROG
    fi
    if [ $1 -eq 0 ];then
      sudo ln -s /var/www/html/scv/scvbin/$PROG /usr/local/bin/$PROG
    elif [ $1 -eq 1 -a -L /usr/local/bin/$PROG ];then
      sudo unlink /usr/local/bin/$PROG
    fi
  done
}

#--------------------------------------------
#ここからスタート
#--------------------------------------------
TEMP=scvsetup.tmp
sudo chmod +x -R /var/www/html/scv/scvbin

#--------------------------------------------
#1.scvコアコマンド1
PROGS="scvdirect scvrm scvremove scvclustd scvsync scvreserved scvmond scvlicense scvshmem scvsqle scvmakeconf"
setup "0"

#--------------------------------------------
#2.scvコアコマンド2
PROGS="scvcpu cpustat scvmem scvremote scvsh scvmount scvgetwd scvclientlog scvstr scvupdate scvcsv scvdummyd scvflow scvdpwd"
setup "0"

#--------------------------------------------
#3.scvコアスクリプト1
PROGS="scvbackup scvbinsync scvclustexec scvconf scvdatesync scvdown.sh scvdown.sh.example scvdownconf scvlog scvvck"
setup "0"

#--------------------------------------------
#4.scvコアスクリプト2
PROGS="scvgetauthcount scvgetlog scvmakekey scvnatconf scvkrbconf scvldapconf scvrestore scvserverdata scvsetup.sh"
setup "0"

#--------------------------------------------
#5.scvコアスクリプト3
PROGS="scvparedit scvprofcp scvfwstartup scvlicupdate scvkerberos scvldap"
setup "0"

#--------------------------------------------
#6.scvコアスクリプト4
PROGS="scvshell scvstartup.sh scvtransfer scvuseradd scvusermod scvuserdel scvusermigrate scvver scvvpncheck scvusermigrate scvshmem_recreate scvrelocate.sh scvffmigrate scvsub"
setup "0"

#--------------------------------------------
#7.scvコアスクリプト
PROGS="revobrconf revobrstat revodtstat scvstat"
setup "0"

#--------------------------------------------
#4.appコマンド (削除のみ)
PROGS="appget appdec applog appremove appsave appsetdisp appdownload appevent appbase64 appllcheck appfssanitize appupload apppar appflow"
setup "1"

#--------------------------------------------
#5.appスクリプト (削除のみ)
PROGS="appxpralog"
setup "1"

#------------------------------------------------
#remove old files
if [ -e /usr/local/bin/slave2master.sh ]; then
  sudo rm /usr/local/bin/slave2master.sh
fi
if [ -e /usr/local/bin/scvtest ]; then
  sudo rm /usr/local/bin/scvtest
fi

#scvfwkey
sudo chmod 775 /var/www/html/scv/scvbin/scvfwsec /var/www/html/scv/scvbin/scvfwpub

#eof
