#!/bin/bash
#------------------------------------------------
#scvstart.sh 4.0.2
#2020/02/14
#Copyright J's Communication co.,ltd.
#
#This script is executed at rc.local.
#  DO NOT CUSTOMIZE THIS.
#------------------------------------------------
LOGFILE="/var/log/scvstartup.log"
RUNTIME=`date +'%Y-%m-%d %H-%M-%S'`
DESTNAT=`cat /var/www/html/scv/.scvconf | grep 'DESTNAT=' | sed -e 's@SCV_DESTNAT=@@g'`
#XPRAPROXY=`cat /var/www/html/scv/.scvconf | grep 'XPRAPROXY=' | sed -e 's@SCV_XPRAPROXY=@@g'`
#if [ -z "$XPRAPROXY" ];then
#  XPRAPROXY=0
#fi

/usr/local/bin/scvlog -bar
echo "==================================================================" >> $LOGFILE 2>&1
echo "[${RUNTIME}] scvstartup.sh starting..." >> $LOGFILE 2>&1
sleep 10
#if [ ! -e /tmp/.scv ]; then
  mkdir /tmp/.scv
  mkdir /tmp/.scv/.par
  chmod 777 -R /tmp/.scv
  rm -f /tmp/.scv/.par/*
#fi
/usr/local/bin/scvsync -chmod                 >> $LOGFILE 2>&1

#for MUTEX shared memory
/usr/local/bin/scvshmem mutex create          >> $LOGFILE 2>&1

#for LICRUN shared memory
/usr/local/bin/scvshmem licrun create         >> $LOGFILE 2>&1

#for NEW AUTHLIMIT, DRUNLIMIT shared memories
/usr/local/bin/scvshmem auth create           >> $LOGFILE 2>&1
/usr/local/bin/scvshmem drun create           >> $LOGFILE 2>&1
##chmod 644 /var/log/auth.log                   >> $LOGFILE 2>&1

#for STZ, VCK and TCK shared memories
/usr/local/bin/scvshmem stz create            >> $LOGFILE 2>&1
/usr/local/bin/scvshmem vck create            >> $LOGFILE 2>&1
/usr/local/bin/scvshmem tck create            >> $LOGFILE 2>&1

#load license
/usr/local/bin/scvlicense -load               >> $LOGFILE 2>&1

#------------------------------------------------
#remove all container on this server
RUNTIME=`date +'%Y-%m-%d %H-%M-%S'`
echo "[${RUNTIME}] removing all containers ..." >> $LOGFILE 2>&1
/usr/local/bin/scvremove -all -y              >> $LOGFILE 2>&1
/usr/local/bin/scvremove -rsv -y              >> $LOGFILE 2>&1

#------------------------------------------------
#synv containers
/usr/local/bin/scvsqle -sync_containers       >> $LOGFILE 2>&1

#------------------------------------------------
#actions for each CLUSTER ROLE
CLUSTER=`/usr/local/bin/scvclustd -cluster`
ROLE=`/usr/local/bin/scvclustd -role`
RUNTIME=`date +'%Y-%m-%d %H-%M-%S'`
if [ "$CLUSTER" != "1" ]; then
  echo "[${RUNTIME}] starting as a stand alone system." >> $LOGFILE 2>&1
  /usr/local/bin/scvclustd -clear             >> $LOGFILE 2>&1
  /usr/local/bin/revodtstat -upper_revodt >> $LOGFILE 2>&1
  setsid php /var/www/html/scv/artisan  queue:work >/dev/null 2>&1 < /dev/null &
else
  if [ $ROLE = "master" ]; then
    echo "[${RUNTIME}] cluster role = $ROLE." >> $LOGFILE 2>&1
    ##scvflow mail queue work daemon (入力待ちが発生するためnullへredirect)
    setsid php /var/www/html/scv/artisan  queue:work >/dev/null 2>&1 < /dev/null &
    /usr/local/bin/revobrstat -sync_all >> $LOGFILE 2>&1
    /usr/local/bin/revodtstat -sync_all >> $LOGFILE 2>&1
    /usr/local/bin/revodtstat -upper_revodt >> $LOGFILE 2>&1
    ##do master specific tasks
  elif  [ $ROLE = "slave" ]; then
    echo "[${RUNTIME}] cluster role = $ROLE." >> $LOGFILE 2>&1
    /usr/local/bin/revobrstat -sync_all >> $LOGFILE 2>&1
    /usr/local/bin/revodtstat -sync_all >> $LOGFILE 2>&1
    /usr/local/bin/revodtstat -upper_revodt >> $LOGFILE 2>&1

    # sync APP_KEY from master
    MASTER=`cat /var/www/html/scv/.scvconf | grep SCV_CLUSTMASTER | cut -d = -f 2`
    MASTER_ENV=`sudo -u scvrun ssh scvrun@${MASTER} cat /var/www/html/scv/.env || echo 'false'`

    if [ "$MASTER_ENV" != 'false' ];then
      MASTER_KEY=`echo "$MASTER_ENV" | grep '^APP_KEY' | cut -d = -f 2`
      if [ -n "$MASTER_KEY" ];then
        sed -i -e "s#APP_KEY=.*#APP_KEY=${MASTER_KEY}#" /var/www/html/scv/.env
      fi
    fi
    ##do master specific tasks
  elif  [ $ROLE = "member" ]; then
    echo "[${RUNTIME}] cluster role = $ROLE." >> $LOGFILE 2>&1
    echo "[${RUNTIME}] sync template."
    /usr/local/bin/scvclustd -synctpl         >> $LOGFILE 2>&1
    ##don't stop mysql.
    #echo "XPRAPROXY=$XPRAPROXY"               >> $LOGFILE 2>&1
    #if [ $XPRAPROXY -eq 0 ];then
    #  service apache2 stop                      >> $LOGFILE 2>&1
    #fi
    service apache2 status                    >> $LOGFILE 2>&1
  else
    echo "[${RUNTIME}] cluster role error = $ROLE." >> $LOGFILE 2>&1
    ##scvflow mail queue work daemon (入力待ちが発生するためnullへredirect)
    setsid php /var/www/html/scv/artisan  queue:work >/dev/null 2>&1 < /dev/null &
  fi
  /usr/local/bin/scvclustd -update            >> $LOGFILE 2>&1
fi

if [ "$DESTNAT" = "2" ];then
  /usr/local/bin/scvfwstartup -up >> $LOGFILE 2>&1
fi

/usr/local/bin/scvsync -sync                  >> $LOGFILE 2>&1
/usr/local/bin/scvclustd -start_boot          >> $LOGFILE 2>&1
/usr/local/bin/scvmond -start_boot            >> $LOGFILE 2>&1
#/usr/local/bin/scvclustd -update              >> $LOGFILE 2>&1
#/usr/local/bin/scvsync -sync                  >> $LOGFILE 2>&1

RUNTIME=`date +'%Y-%m-%d %H-%M-%S'`
echo "[${RUNTIME}] end of scvstartup."        >> $LOGFILE 2>&1

#eof
