<!-- scv/resources/views/layout/default.blade.php -->
<!doctype html>
<html lang="ja">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  
  <meta http-equiv="Pragma" content="no-cache" />
  <meta http-equiv="cache-control" content="no-cache" />
  <meta http-equiv="expires" content="0" />
  <meta http-equiv="Content-Security-Policy" content="script-src 'self' 'unsafe-inline'">

  <meta name="description" content="Secure Console Vitrual">
  <meta name="author" content="tnakamura@jscom.co.jp">
  <title>SCV</title>

  <!-- Bootstrap core CSS -->
  <link href="<?php echo asset('css/bootstrap.min.css'); ?>" rel="stylesheet">

  <!-- common style -->
  <link rel="stylesheet" href="<?php echo asset('css/scvcommon.css'); ?>" type="text/css">

  <?php echo $__env->yieldContent('head'); ?>
</head>
<body>
<main>
  <nav class="navbar navbar-inverse navbar-fixed-top">
      <div class="navbar-header">
        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
          <span class="sr-only">SCV Manager</span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
        </button>
        <?php if(Auth::check() && empty(Auth::user()->tmp_pwd)): ?>
          <a class="navbar-brand" href="<?php echo e(URL::to('/scvmanager')); ?>">SCV Manager</a>
        <?php else: ?>
          <a class="navbar-brand" href="">SCV Manager</a>
        <?php endif; ?>
      </div>
      <div id="navbar" class="navbar-collapse collapse">
        <ul class="nav navbar-nav">
          <?php if(Auth::check()): ?>
            <?php if(empty(Auth::user()->tmp_pwd)): ?>
              <?php if(Auth::user()->organization_id == "1"): ?>
                <li class="dropdown">
                  <a href="<?php echo e(URL::to('/scvmanager/scvconf')); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">システム設定</a>
                  <ul class="dropdown-menu hidden-xs" style="width:22em;">
                    <li><a href="<?php echo e(URL::to('/scvmanager/scvconf/system/edit')); ?>">SYSTEMの変更</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/users')); ?>">管理者アカウント管理</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/scvxlicense/list')); ?>">ライセンス情報</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/scvxlicense')); ?>">ライセンス登録</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/profile_group')); ?>">プロファイルテンプレート管理<span class="scvx-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/pac')); ?>">Pacファイルアップロード<span class="scvx-icon pull-right"></span><span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/serverlist')); ?>">URLリダイレクト管理<span class="scvx-icon pull-right"></span><span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/appsettings')); ?>">アプリケーションマスタ管理<span class="revodt-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/emergency_mode')); ?>">災害時モード管理</a></li>
                    <?php if(App\Libs\ConfHelper::isPpuMaster()): ?>
                      <li><a href="<?php echo e(URL::to('/scvmanager/ppu')); ?>">PPUメール管理</a></li>
                    <?php endif; ?>
                  </ul>
                </li>
              <?php else: ?>
              <li class="dropdown">
                <a href="<?php echo e(URL::to('/scvmanager/users')); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">管理者アカウント管理</a>
              </li>
              <li><a href="<?php echo e(URL::to('/scvmanager/profile_group')); ?>">プロファイルテンプレート管理</a></li>
              <?php endif; ?>
                <li class="dropdown">
                  <?php if(Auth::user()->organization_id == "1"): ?>
                  <a href="<?php echo e(URL::to('/scvmanager/organization')); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">組織管理</a>
                  <ul class="dropdown-menu hidden-xs">
                    <li><a href="<?php echo e(URL::to('/scvmanager/organization/create')); ?>">組織作成</a></li>
                  </ul>
                  <?php else: ?>
                  <a href="<?php echo e(URL::to('/scvmanager/organization/'. Auth::user()->organization)); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">組織管理</a>
                  <?php endif; ?>
                </li>
                <li class="dropdown">
                  <a href="<?php echo e(URL::to('/scvmanager/scvgroups')); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">グループ管理</a>
                  <ul class="dropdown-menu hidden-xs" style="width:16em;">
                    <li><a href="<?php echo e(URL::to('/scvmanager/scvgroups/create')); ?>">グループ作成</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/firefoxprof')); ?>">Firefox設定<span class="scvx-icon pull-right"></span><span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/scvx_chrome_settings')); ?>">SCVX Chrome設定<span class="scvx-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/share')); ?>">共有フォルダ設定</a></li>
                    <?php if(Auth::user()->organization_id == "1"): ?>
                    <li><a href="<?php echo e(URL::to('/scvmanager/scvgroups/csv')); ?>">グループ一括登録</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/br_settings')); ?>">RevoBrowser設定<span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/visionprof')); ?>">デスクトップ設定<span class="revodt-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/vpn_settings')); ?>">VPN設定<span class="revobr-icon pull-right"></span><span class="revodt-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/proxy_settings')); ?>">Proxy設定<span class="revobr-icon pull-right"></span><span class="revodt-icon pull-right"></span></a></li>
                    <?php endif; ?>
                  </ul>
                </li>
                <li class="dropdown">
                  <a href="<?php echo e(URL::to('/scvmanager/scvusers')); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">ユーザ管理</a>
                  <ul class="dropdown-menu hidden-xs">
                    <li><a href="<?php echo e(URL::to('/scvmanager/scvusers/create')); ?>">ユーザ作成</a></li>
                    <?php if(Auth::user()->organization_id == "1"): ?>
                    <li><a href="<?php echo e(URL::to('/scvmanager/batch')); ?>">ユーザ一括登録</a></li>
                    <?php endif; ?>
                  </ul>
                </li>
                <?php if(Auth::user()->organization_id == "1"): ?>
                <li class="dropdown">
                  <a href="<?php echo e(URL::to('/scvmanager/devices')); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">端末管理</a>
                  <ul class="dropdown-menu hidden-xs" style="width:20em;">
                    <li><a href="<?php echo e(URL::to('/scvmanager/devices/revobr/policy')); ?>">RevoWorks Browser Updater<span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/devices/revodt_list')); ?>">RevoWorks Desktop 端末一覧<span class="revodt-icon pull-right"></span></a></li>
                  </ul>
                </li>
                <?php endif; ?>
              <?php if(Auth::user()->organization_id == "1"): ?>
                <li class="dropdown">
                  <a href="<?php echo e(URL::to('/scvmanager/reports')); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">レポート</a>
                  <ul class="dropdown-menu hidden-xs">
                    <li><a href="<?php echo e(URL::to('/scvmanager/logsearch')); ?>">ユーザログ検索</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/filelogsearch')); ?>">ファイルログ検索</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/updater_log')); ?>">アップデータログ検索</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/reportrank')); ?>">ユーザランキング</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/reportutil')); ?>">ユーザ利用状況</a></li>
                    <li><a href="<?php echo e(URL::to('/scvmanager/reportperf')); ?>">サーバ稼動状況</a></li>
                  </ul>
                </li>
                <li><a href="<?php echo e(URL::to('/about')); ?>">SCVについて</a></li>
              <?php else: ?>
                <li class="dropdown">
                  <a href="<?php echo e(URL::to('/scvmanager/reports')); ?>" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">レポート</a>
                  <ul class="dropdown-menu hidden-xs">
                    <li><a href="<?php echo e(URL::to('/scvmanager/reportrank')); ?>">ユーザランキング</a></li>
                  </ul>
                </li>
              <?php endif; ?>
            <?php endif; ?>
          <?php endif; ?>
        </ul>
        <?php if(!Auth::guest()): ?>
        
        <ul class="nav navbar-nav navbar-right hidden-xs">
          <?php if(Auth::user()->organization_id == "1"): ?>
            <li data-toggle="bottom" data-placement="right" title="SCVについて"><a href="<?php echo e(URL::to('/about')); ?>"><span class="glyphicon glyphicon-question-sign"></span></a></li>
          <?php endif; ?>
          <li><a href="#" data-toggle="bottom" data-placement="right" title="<?php echo e(Auth::user()->username); ?>"><span class="glyphicon glyphicon-user"></span></a></li>
          <li data-toggle="bottom" data-placement="right" title="ログアウト"><a href="<?php echo e(URL::to('/scvmanager/logout')); ?>"><span class="glyphicon glyphicon-log-out"></span></a></li>
          <li>&nbsp;&nbsp;&nbsp;</li>
        </ul>
        
        <ul class="nav navbar-nav navbar-right visible-xs">
          <?php if(Auth::user()->organization_id == "1"): ?>
            <li><a href="<?php echo e(URL::to('/about')); ?>">SCVについて</a></li>
          <?php endif; ?>
          <li><a href="#"><span class="glyphicon glyphicon-user"></span><?php echo e(Auth::user()->username); ?></a></li>
          <li><a href="<?php echo e(URL::to('/scvmanager/logout')); ?>">ログアウト</a></li>
        </ul>
        <?php endif; ?>
      </div>
  </nav>

  <div class="container-fluid">

    <div class="starter-template">
    </div>
<?php if(App\Libs\ClusterHelper::isCluster()): ?>
  
  <?php if(App\Libs\ClusterHelper::isMaster() && env('DB_HOST_SLAVE') == null): ?>
    <br>
    <div class="alert alert-danger alert-dismissible" role="alert">
      <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
      .envにSlaveのホストを追記して下さい。
    </div>
  <?php endif; ?>

  
  <?php if( !App\Libs\ClusterHelper::isMasterActive() && !App\Libs\ClusterHelper::isMasterUpdating() ): ?>
    <br>
    <div class="alert alert-danger alert-dismissible" role="alert">
      <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
      MasterサーバがActiveではありません。
    </div>
  <?php endif; ?>

  <?php if(!App\Libs\ClusterHelper::isSlaveAlive()): ?>
    <br>
    <div class="alert alert-danger alert-dismissible" role="alert">
      <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
      Slaveサーバがダウンしています。
    </div>
  <?php elseif(App\Libs\ClusterHelper::isSlaveAlive() && !App\Libs\ClusterHelper::isSlaveActive() && !App\Libs\ClusterHelper::isSlaveUpdating() ): ?>
    <br>
    <div class="alert alert-danger alert-dismissible" role="alert">
      <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
      SlaveサーバがActiveではありません。
    </div>
  <?php endif; ?>
<?php endif; ?>

<?php if(!sem_acquire(sem_get(config('scv.csv_sem_key')), true)): ?>
<br>
<div class="alert alert-info alert-dismissible" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
    CSV一括処理を行っています。処理が完了するまでSCVManagerでの追加、変更、削除処理が行えません。
</div>
<?php endif; ?>

<?php if(App\Libs\LicenseHelper::isUserLicenseExeeded()): ?>
  <br>
  <div class="alert alert-danger alert-dismissible" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
    登録ユーザ数がライセンスの上限を超えています。ユーザの削除またはライセンスの追加を行ってください。
  </div>
<?php endif; ?>

<?php if(App\Libs\ConfHelper::is_illegal()): ?>
  <div class="alert alert-danger alert-dismissible" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
    認証方式の設定が誤っています。
  </div>
<?php else: ?>
    <div><?php echo $__env->yieldContent('content'); ?></div>
<?php endif; ?>


  </div>
  <script type="text/javascript" src="<?php echo asset('js/jquery-1.11.3.min.js'); ?>"></script>
  <script type="text/javascript" src="<?php echo asset('js/Chart.min.js'); ?>"></script>
  <script src="<?php echo asset('js/bootstrap.min.js'); ?>"></script>
  <script src="<?php echo asset('js/scvmanager/layout.js'); ?>"></script>
  <?php echo $__env->yieldContent('script'); ?>
</main>
<footer>
    <p class="pull-center"><small><?php echo e(config('scv.copyright')); ?></small></p>
</footer>
</body>
</html>
